/*
 * Decompiled with CFR 0.152.
 */
package de.survivalnight.luna.rtp.logic;

import de.survivalnight.luna.rtp.Rtp;
import de.survivalnight.luna.rtp.logic.ColorUtil;
import de.survivalnight.luna.rtp.logic.SafeLocationFinder;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class RtpManager {
    private static final HashMap<UUID, Long> cooldowns = new HashMap();

    public static void teleportPlayer(Player player, String worldName, int range) {
        if (!RtpManager.checkCooldown(player)) {
            return;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            RtpManager.send(player, "messages.world-not-found");
            return;
        }
        SafeLocationFinder.findSafeLocationAsync(world, range, loc -> {
            if (loc == null) {
                RtpManager.send(player, "messages.teleport-fail");
            } else {
                player.teleportAsync(loc);
                RtpManager.send(player, "messages.teleport-success");
                cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
            }
        });
    }

    private static boolean checkCooldown(Player player) {
        long last;
        long remaining;
        long now = System.currentTimeMillis();
        long cooldown = (long)Rtp.getInstance().getConfig().getInt("cooldown-seconds", 60) * 1000L;
        if (player.hasPermission("rtp.bypass")) {
            return true;
        }
        if (cooldowns.containsKey(player.getUniqueId()) && (remaining = cooldown - (now - (last = cooldowns.get(player.getUniqueId()).longValue()))) > 0L) {
            String msg = Rtp.getInstance().getConfig().getString("messages.cooldown-wait", "").replace("<seconds>", String.valueOf(remaining / 1000L));
            player.sendMessage(ColorUtil.mm(msg));
            return false;
        }
        return true;
    }

    private static void send(Player p, String path) {
        String msg = Rtp.getInstance().getConfig().getString(path, "");
        if (!msg.isEmpty()) {
            p.sendMessage(ColorUtil.mm(msg));
        }
    }
}

