/*
 * Decompiled with CFR 0.152.
 */
package de.survivalnight.luna.rtp.logic;

import de.survivalnight.luna.rtp.Rtp;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class SafeLocationFinder {
    private static final Random random = new Random();
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();

    public static void findSafeLocationAsync(World world, int range, Consumer<Location> callback) {
        SafeLocationFinder.tryFindSafeLocation(world, range, callback, 5000L, true);
    }

    private static void tryFindSafeLocation(World world, int range, Consumer<Location> callback, long timeoutMs, boolean allowRetry) {
        THREAD_POOL.submit(() -> {
            long startTime = System.currentTimeMillis();
            for (int attempts = 0; attempts < 1000; ++attempts) {
                Location loc;
                int y;
                int z;
                if (System.currentTimeMillis() - startTime > timeoutMs) {
                    if (allowRetry) {
                        SafeLocationFinder.tryFindSafeLocation(world, range, callback, timeoutMs, false);
                    } else {
                        Bukkit.getScheduler().runTask((Plugin)Rtp.getInstance(), () -> callback.accept(null));
                    }
                    return;
                }
                int x = random.nextInt(range * 2) - range;
                if (SafeLocationFinder.isEmptyChunk(world, x, z = random.nextInt(range * 2) - range) || (y = SafeLocationFinder.getSurfaceY(world, x, z)) == -1 || !SafeLocationFinder.isSafe(loc = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5))) continue;
                Bukkit.getScheduler().runTask((Plugin)Rtp.getInstance(), () -> callback.accept(loc));
                return;
            }
            if (allowRetry) {
                SafeLocationFinder.tryFindSafeLocation(world, range, callback, timeoutMs, false);
            } else {
                Bukkit.getScheduler().runTask((Plugin)Rtp.getInstance(), () -> callback.accept(null));
            }
        });
    }

    private static boolean isEmptyChunk(World world, int x, int z) {
        Chunk chunk = world.getChunkAt(x >> 4, z >> 4);
        for (int y = world.getMinHeight(); y < world.getMaxHeight(); y += 8) {
            Block block = chunk.getBlock(x & 0xF, y, z & 0xF);
            if (block.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static int getSurfaceY(World world, int x, int z) {
        World.Environment env = world.getEnvironment();
        if (env == World.Environment.NETHER) {
            for (int y = 30; y < 118; ++y) {
                if (!SafeLocationFinder.hasEnoughSpace(world, x, y, z)) continue;
                return y;
            }
            return -1;
        }
        if (env == World.Environment.THE_END) {
            for (int y = 50; y < world.getMaxHeight() - 2; ++y) {
                Material ground = world.getBlockAt(x, y - 1, z).getType();
                if (ground != Material.END_STONE && ground != Material.OBSIDIAN || !SafeLocationFinder.hasEnoughSpace(world, x, y, z)) continue;
                return y;
            }
            return -1;
        }
        int y = world.getHighestBlockYAt(x, z);
        if (y <= world.getMinHeight() + 1) {
            return -1;
        }
        return SafeLocationFinder.hasEnoughSpace(world, x, y + 1, z) ? y + 1 : -1;
    }

    private static boolean hasEnoughSpace(World world, int x, int y, int z) {
        return world.getBlockAt(x, y, z).getType().isAir() && world.getBlockAt(x, y + 1, z).getType().isAir();
    }

    private static boolean isSafe(Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return false;
        }
        Material ground = loc.clone().subtract(0.0, 1.0, 0.0).getBlock().getType();
        if (ground.name().contains("LAVA") || ground.name().contains("WATER") || ground == Material.CACTUS || ground == Material.FIRE || ground == Material.AIR) {
            return false;
        }
        return world.getEnvironment() != World.Environment.NETHER || !(loc.getY() >= 120.0);
    }
}

