StartupEvents.registry('palladium:abilities', (event) => {

    event.create('ninjago:aoe_damage')

        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))

        .addProperty('radius', 'float', 10, 'Radius in which surrounding entities will be damaged')
        .addProperty('damage', 'float', 3.0, 'Damage the ability will deal')
		.addProperty('fire_seconds', 'float', 0.0, 'How many seconds the entity should be on fire')
		.addProperty('tag_ex', 'string', 'exclusion_tag', 'Tag that exlcudes entities if desired')
		.addProperty('damage_type', 'string', 'minecraft:player_attack', 'Type of damage.')

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
				const damage_type = entry.getPropertyByName('damage_type');
				const tag_ex = entry.getPropertyByName('tag_ex');
				const firetick = entry.getPropertyByName('fire_seconds');
                const damage = entry.getPropertyByName('damage');
                const radius = entry.getPropertyByName('radius') * 2.0;
                const targets = entity.serverLevel().getEntities(entity, AABB.ofSize(entity.position(), radius, radius, radius)).toArray();
				
                for (let j = 0; j < targets.length; j++) {
                            if (targets[j] !== entity && !containsTag(targets[j].getTags().toArray(), tag_ex) && targets[j].type !== "minecraft:item" && targets[j].type !== "minecraft:item_frame" && targets[j].type !== "minecraft:glow_item_frame" && targets[j].type !== "minecraft:armor_stand" && targets[j].type !== "palladium:suit_stand") {
                                entity.server.runCommandSilent("execute as " + targets[j].uuid + " at @s run damage @s " + damage + " " + damage_type + " by " + entity.uuid);
								targets[j].setSecondsOnFire(firetick);
                        }
                    }
            }
        })
});

function containsTag(tags, tag) {
    for (let i = 0; i < tags.length; i++) {
        if(tags[i].equals(tag)) {
            return true;
        }
    }
    return false;
}

StartupEvents.registry("palladium:abilities", event => {

    event.create("ninjago:entity_damage")
        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('Make an actionbar using a property.')
        .addProperty("property", "string", 'assorted.flight_speed', "The property")
        .addProperty("damage_type", "string", 'property', "Wheter to use the property or a set amount")
        .addProperty("amount", "integer", 1, "The amount")
        .addProperty("distance", "integer", 1, "The distance")
        .addProperty("effect", "string", 'ninjago:burning', "Effect to apply")
        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
                if (entity.isPlayer()) var username = entity.getGameProfile().getName();
                //The Property
                let distance = entry.getPropertyByName('distance')
                let target = entity.rayTrace(distance).entity
                let prop = entry.getPropertyByName('property')
                let property = palladium.getProperty(entity, prop)
                let damage_type = entry.getPropertyByName('damage_type')
                let amount = entry.getPropertyByName('amount')
                let effect = entry.getPropertyByName('effect')
                if (target != null && target.isLiving()) {
                    if (damage_type == 'property') {
                        target.attack(property)
                        target.potionEffects.add(effect, 20, 0, true, true)
                    }
                    if (damage_type == 'set') {
                        target.attack(amount)
                        target.potionEffects.add(effect, 20, 0, true, true)
                    }
                }
            }
        })
});