/*
 * Decompiled with CFR 0.152.
 */
package dev.sweetberry.more_than_a_foxbox.block;

import dev.sweetberry.more_than_a_foxbox.block.entity.PlushieHoldingBlockEntity;
import dev.sweetberry.more_than_a_foxbox.data.MtfbComponents;
import dev.sweetberry.more_than_a_foxbox.data.PlushieDataComponent;
import dev.sweetberry.more_than_a_foxbox.item.MtfbItems;
import dev.sweetberry.more_than_a_foxbox.network.clientbound.ClientboundPlushieSquish;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlushieHoldingBlock
extends class_2237 {
    public static final class_2746 POWERED = class_2741.field_12484;

    protected PlushieHoldingBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @NotNull
    public abstract class_1269 crouchUseWithoutItem(class_2680 var1, class_1937 var2, class_2338 var3, class_1657 var4, class_3965 var5, PlushieHoldingBlockEntity var6);

    @NotNull
    public abstract class_2591<? extends PlushieHoldingBlockEntity> getPlushieHoldingBlockEntityType();

    @NotNull
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        Optional maybeEntity = level.method_35230(pos, this.getPlushieHoldingBlockEntityType());
        if (maybeEntity.isEmpty()) {
            return super.method_55766(state, level, pos, player, hitResult);
        }
        PlushieHoldingBlockEntity entity = (PlushieHoldingBlockEntity)((Object)maybeEntity.get());
        if (player.method_5715() && !player.method_21701(level, pos, player.method_68876())) {
            return this.crouchUseWithoutItem(state, level, pos, player, hitResult, entity);
        }
        this.squishPlushie(level, pos, player, entity);
        entity.playSound(level, pos);
        if (entity.hasPlushieData()) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, @Nullable class_9904 orientation, boolean movedByPiston) {
        if (level.method_8608()) {
            return;
        }
        boolean powered = level.method_49803(pos);
        if (powered == (Boolean)state.method_11654((class_2769)POWERED)) {
            return;
        }
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        if (!powered) {
            return;
        }
        Optional maybeEntity = level.method_35230(pos, this.getPlushieHoldingBlockEntityType());
        if (maybeEntity.isEmpty()) {
            return;
        }
        PlushieHoldingBlockEntity entity = (PlushieHoldingBlockEntity)((Object)maybeEntity.get());
        this.squishPlushie(level, pos, null, entity);
        entity.playSound(level, pos);
    }

    private void squishPlushie(class_1937 level, class_2338 pos, @Nullable class_1657 player, PlushieHoldingBlockEntity entity) {
        if (!level.method_8608()) {
            for (class_3222 serverPlayer : PlayerLookup.tracking((class_2586)entity)) {
                if (serverPlayer.method_5779((class_1297)player)) continue;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new ClientboundPlushieSquish(pos));
            }
        } else {
            entity.resetStretchSquish();
        }
    }

    protected boolean method_9506(class_2680 state) {
        return true;
    }

    public class_1799 getPlushieStack(PlushieHoldingBlockEntity plushie) {
        Optional<PlushieDataComponent> maybePlushieData = plushie.getPlushieData();
        if (maybePlushieData.isEmpty()) {
            return class_1799.field_8037;
        }
        PlushieDataComponent plushieData = maybePlushieData.get();
        class_1799 stack = MtfbItems.PLUSHIE.get().method_7854();
        stack.method_57379(MtfbComponents.PLUSHIE.get(), (Object)plushieData);
        plushie.getName().ifPresent(it -> stack.method_57379(class_9334.field_49631, it));
        return stack;
    }

    @NotNull
    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 params) {
        PlushieHoldingBlockEntity plushie;
        class_1799 stack;
        ArrayList<class_1799> items = new ArrayList<class_1799>(super.method_9560(state, params));
        class_2586 blockEntity = (class_2586)params.method_51876(class_181.field_1228);
        if (blockEntity instanceof PlushieHoldingBlockEntity && (stack = this.getPlushieStack(plushie = (PlushieHoldingBlockEntity)blockEntity)) != class_1799.field_8037) {
            items.add(stack);
        }
        return items;
    }

    protected boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return PlushieHoldingBlock.method_20044((class_4538)level, (class_2338)pos.method_10074(), (class_2350)class_2350.field_11036);
    }
}

