/*
 * Decompiled with CFR 0.152.
 */
package dev.sweetberry.more_than_a_foxbox.block.entity;

import dev.sweetberry.more_than_a_foxbox.data.MtfbComponents;
import dev.sweetberry.more_than_a_foxbox.data.PlushieDataComponent;
import dev.sweetberry.more_than_a_foxbox.data.PlushieVariant;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public abstract class PlushieHoldingBlockEntity
extends class_2586 {
    public static final String PLUSHIE_KEY = "plushie";
    public static final String NAME_KEY = "name";
    public static final float STRETCH_TIME = 10.0f;
    public static final float SQUISH_TIME = 10.0f;
    public static final float SCALE_SLOWNESS = 2.0f;
    private float deltaStretch = 0.0f;
    private float deltaSquish = 10.0f;

    public PlushieHoldingBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void setPlushieData(PlushieDataComponent component, Optional<class_2561> name) {
        class_9326.class_9327 builder = class_9326.method_57841().method_57854(MtfbComponents.PLUSHIE.get(), (Object)component);
        name.ifPresent(it -> builder.method_57854(class_9334.field_49631, it));
        this.method_58685(this.method_58693(), builder.method_57852());
        this.method_5431();
    }

    public void removePlushieData() {
        this.method_58685(this.method_58693(), class_9326.method_57841().method_57853(MtfbComponents.PLUSHIE.get()).method_57853(class_9334.field_49631).method_57852());
        this.method_5431();
    }

    public Optional<PlushieDataComponent> getPlushieData() {
        return Optional.ofNullable((PlushieDataComponent)this.method_58693().method_58694(MtfbComponents.PLUSHIE.get()));
    }

    public boolean hasPlushieData() {
        return this.method_58693().method_57832(MtfbComponents.PLUSHIE.get());
    }

    public Optional<class_2561> getName() {
        return Optional.ofNullable((class_2561)this.method_58693().method_58694(class_9334.field_49631));
    }

    public Optional<class_6880.class_6883<PlushieVariant>> getPlushieVariant() {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        return this.getPlushieData().flatMap(plushieDataComponent -> this.field_11863.method_30349().method_58561(plushieDataComponent.variant()));
    }

    public abstract Optional<class_2960> getPoseModel(class_2680 var1);

    protected void method_11014(class_11368 input) {
        Optional component = input.method_71426(PLUSHIE_KEY, PlushieDataComponent.CODEC);
        Optional name = input.method_71426(NAME_KEY, class_8824.field_46597);
        component.ifPresent(it -> this.setPlushieData((PlushieDataComponent)it, name));
    }

    protected void method_11007(class_11372 output) {
        this.getPlushieData().ifPresent(it -> output.method_71468(PLUSHIE_KEY, PlushieDataComponent.CODEC, it));
        this.getName().ifPresent(it -> output.method_71468(NAME_KEY, class_8824.field_46597, it));
    }

    public void method_5431() {
        super.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14178().method_14128(this.field_11867);
        }
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public void playSound(class_1937 level, class_2338 pos) {
        if (level.method_8608()) {
            return;
        }
        PlushieDataComponent variant = (PlushieDataComponent)this.method_58693().method_58694(MtfbComponents.PLUSHIE.get());
        if (variant == null) {
            return;
        }
        Optional<class_3414> maybeSound = variant.getInteractionSound(level.method_30349());
        if (maybeSound.isEmpty()) {
            return;
        }
        class_243 center = pos.method_46558();
        level.method_47967(null, center.field_1352, center.field_1351, center.field_1350, maybeSound.get(), class_3419.field_15248, 1.0f, 1.0f, level.field_9229.method_43055());
    }

    public float getDeltaStretch() {
        return this.deltaStretch;
    }

    public void setDeltaStretch(float deltaStretch) {
        this.deltaStretch = deltaStretch;
    }

    public float getDeltaSquish() {
        return this.deltaSquish;
    }

    public void setDeltaSquish(float deltaSquish) {
        this.deltaSquish = deltaSquish;
    }

    public void resetStretchSquish() {
        this.deltaStretch = -5.0f;
        this.deltaSquish = 5.0f;
    }
}

