/*
 * Decompiled with CFR 0.152.
 */
package dev.sweetberry.more_than_a_foxbox.client.block.entity.render;

import dev.sweetberry.more_than_a_foxbox.MoreThanAFoxbox;
import dev.sweetberry.more_than_a_foxbox.block.BoxBlock;
import dev.sweetberry.more_than_a_foxbox.block.entity.BoxBlockEntity;
import dev.sweetberry.more_than_a_foxbox.block.entity.PlushieHoldingBlockEntity;
import dev.sweetberry.more_than_a_foxbox.block.property.MtfbBlockProperties;
import dev.sweetberry.more_than_a_foxbox.client.MoreThanAFoxboxClient;
import dev.sweetberry.more_than_a_foxbox.client.block.entity.render.PlushieHoldingBlockEntityRenderState;
import dev.sweetberry.more_than_a_foxbox.util.OctalDirection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class PlushieBlockEntityRenderer
implements class_827<PlushieHoldingBlockEntity, PlushieHoldingBlockEntityRenderState> {
    private final Map<class_2960, class_1087> models = new HashMap<class_2960, class_1087>();
    private final class_5614.class_5615 renderContext;

    public PlushieBlockEntityRenderer(class_5614.class_5615 context) {
        this.renderContext = context;
    }

    @NotNull
    public PlushieHoldingBlockEntityRenderState createRenderState() {
        return new PlushieHoldingBlockEntityRenderState();
    }

    public void extractRenderState(PlushieHoldingBlockEntity blockEntity, PlushieHoldingBlockEntityRenderState state, float partialTick, class_243 vec3, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)state, partialTick, vec3, crumblingOverlay);
        state.deltaStretch = blockEntity.getDeltaStretch();
        state.deltaSquish = blockEntity.getDeltaSquish();
        if (state.deltaStretch < 0.0f) {
            blockEntity.setDeltaStretch(state.deltaStretch + partialTick / 2.0f);
        }
        if (blockEntity.getDeltaSquish() < 10.0f) {
            blockEntity.setDeltaSquish(blockEntity.getDeltaSquish() + partialTick / 2.0f);
        }
        state.model = null;
        state.isBox = blockEntity instanceof BoxBlockEntity;
        Optional<class_2960> optionalPoseModel = blockEntity.getPoseModel(blockEntity.method_11010());
        if (blockEntity instanceof BoxBlockEntity && optionalPoseModel.isEmpty()) {
            return;
        }
        class_2960 poseModel = optionalPoseModel.orElseGet(() -> MoreThanAFoxbox.id("more_than_a_foxbox/placeholder"));
        class_1092 modelManager = class_310.method_1551().method_1554();
        state.model = this.models.computeIfAbsent(poseModel, asset -> (class_1087)modelManager.getModel(MoreThanAFoxboxClient.MODEL_KEYS.get(asset)));
        if (state.model == null) {
            state.model = (class_1087)modelManager.getModel(MoreThanAFoxboxClient.MODEL_KEYS.get(class_2960.method_60655((String)"more_than_a_foxbox", (String)"more_than_a_foxbox/placeholder")));
        }
        if (state.model == null) {
            MoreThanAFoxbox.LOGGER.error("Cannot find placeholder plushie.");
        }
    }

    public void submit(PlushieHoldingBlockEntityRenderState state, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (state.model == null) {
            return;
        }
        poseStack.method_22903();
        OctalDirection direction = (OctalDirection)((Object)state.field_62674.method_11654(MtfbBlockProperties.FACING));
        Matrix4f rotationTransform = BoxBlock.pointBlockToward(direction, 0.5f);
        poseStack.method_34425((Matrix4fc)rotationTransform);
        float stretch = 1.0f - state.deltaStretch / 10.0f;
        float squish = state.deltaSquish / 10.0f;
        poseStack.method_46416(this.scaleInPlace(stretch), 0.0f, 0.0f);
        if (state.isBox) {
            poseStack.method_46416(0.0f, this.scaleInPlace(squish), 0.0f);
        }
        poseStack.method_22905(stretch, squish, 1.0f);
        submitNodeCollector.method_73484(poseStack, class_4722.method_29382(), state.model, 1.0f, 1.0f, 1.0f, state.field_62676, class_4608.field_21444, 0);
        poseStack.method_22909();
    }

    private float scaleInPlace(float scale) {
        return 1.0f - scale / 2.0f - 0.5f;
    }
}

