package com.glisco.disenchanter;

import com.glisco.disenchanter.catalyst.Catalyst;
import com.glisco.disenchanter.catalyst.CatalystRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3218;
import net.minecraft.class_3914;

public class DisenchanterScreenHandler extends class_1703 {

    private final class_3914 context;
    private final class_1263 inventory;

    //This constructor gets called on the client when the server wants it to open the screenHandler,
    //The client will call the other constructor with an empty Inventory and the screenHandler will automatically
    //sync this empty inventory with the inventory on the server.
    public DisenchanterScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    //This constructor gets called from the BlockEntity on the server without calling the other constructor first, the server knows the inventory of the container
    //and can therefore directly provide it as an argument. This inventory will then be synced to the client.
    public DisenchanterScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(Disenchanter.DISENCHANTER_SCREEN_HANDLER, syncId);
        this.inventory = new class_1277(4);
        this.context = context;
        this.method_7621(new class_1735(inventory, 0, 17, 76) {
            @Override
            public boolean method_7680(class_1799 stack) {
                return stack.method_7942() && !stack.method_31573(Disenchanter.BLACKLIST);
            }
        });
        this.method_7621(new class_1735(inventory, 1, 143, 76) {
            @Override
            public boolean method_7680(class_1799 stack) {
                return stack.method_7909() == class_1802.field_8529;
            }
        });
        this.method_7621(new class_1735(inventory, 2, 80, 49) {
            public boolean method_7680(class_1799 stack) {
                return CatalystRegistry.isCatalyst(stack.method_7909());
            }
        });
        this.method_7621(new class_1735(inventory, 3, 80, 22) {
            public boolean method_7680(class_1799 stack) {
                return false;
            }
        });

        //This will place the slot in the correct locations for a 3x3 Grid. The slots exist on both server and client!
        //This will not render the background of the slots however, this is the Screens job
        int m;
        int l;
        //The player inventory
        for (m = 0; m < 3; ++m) {
            for (l = 0; l < 9; ++l) {
                this.method_7621(new class_1735(playerInventory, l + m * 9 + 9, 8 + l * 18, 108 + m * 18));
            }
        }
        //The player Hotbar
        for (m = 0; m < 9; ++m) {
            this.method_7621(new class_1735(playerInventory, m, 8 + m * 18, 166));
        }

    }

    public void onDisenchantRequest() {
        var contOpt = context.method_17395((world, blockPos) -> world);
        if (contOpt.isEmpty()) return;

        final var world = contOpt.get();
        final var catalystStack = inventory.method_5438(2);
        if (!Disenchanter.getConfig().allowDisenchantingWithoutCatalyst && catalystStack.method_7960()) return;

        final var catalyst = CatalystRegistry.get(catalystStack);
        var processedInput = catalyst.transformInput(inventory.method_5438(0).method_7972(), world.field_9229);

        inventory.method_5447(3, catalyst.generateOutput(inventory.method_5438(0).method_7972(), world.field_9229));
        inventory.method_5447(0, processedInput);

        decrement(inventory, 1);
        if (catalyst != Catalyst.DEFAULT) decrement(inventory, 2, CatalystRegistry.getRequiredItemCount(catalyst));

        this.method_7623();

        //noinspection OptionalGetWithoutIsPresent
        var pos = context.method_17395((w, blockPos) -> blockPos).get();

        DisenchanterNetworking.CHANNEL.serverHandle((class_3218) world, pos).send(new DisenchanterNetworking.DisenchantEvent(pos));
    }

    public boolean method_7597(class_1657 player) {
        return method_17695(context, player, Disenchanter.DISENCHANTER_BLOCK);
    }

    // Shift + Player Inv Slot
    @Override
    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.inventory.method_5439()) {
                if (!this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(originalStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }

            if (originalStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }

        return newStack;
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, blockPos) -> this.method_7607(player, this.inventory));
    }

    private static void decrement(class_1263 inv, int idx) {
        decrement(inv, idx, 1);
    }

    private static void decrement(class_1263 inv, int idx, int by) {
        inv.method_5438(idx).method_7934(by);
        if (inv.method_5438(idx).method_7960()) inv.method_5447(idx, class_1799.field_8037);
    }
}