package com.glisco.disenchanter.client;

import com.glisco.disenchanter.Disenchanter;
import com.glisco.disenchanter.DisenchanterNetworking;
import com.glisco.disenchanter.DisenchanterScreenHandler;
import com.glisco.disenchanter.VisitableTextContent;
import com.glisco.disenchanter.catalyst.Catalyst;
import com.glisco.disenchanter.catalyst.CatalystRegistry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_5250;

@Environment(EnvType.CLIENT)
public class DisenchanterClient implements ClientModInitializer {

    @Override
    public void onInitializeClient() {
        class_3929.method_17542(Disenchanter.DISENCHANTER_SCREEN_HANDLER, DisenchanterScreen::new);

        DisenchanterNetworking.initClient();

        ItemTooltipCallback.EVENT.register((stack, tooltipContext, tooltipType, lines) -> {
            if (class_310.method_1551().field_1724 == null) return;
            if (!(class_310.method_1551().field_1724.field_7512 instanceof DisenchanterScreenHandler handler)) {
                return;
            }

            if (stack.method_31573(Disenchanter.BLACKLIST)) {
                lines.add(1, class_2561.method_43471("text.disenchanter.blacklisted").method_27692(class_124.field_1063));
            }

            final var catalyst = CatalystRegistry.getUnchecked(stack);
            if (catalyst == Catalyst.DEFAULT) return;

            final var catalystStack = handler.method_7611(2).method_7677();
            if (!catalystStack.method_7960() && stack == catalystStack) {
                int requiredCount = CatalystRegistry.getRequiredItemCount(catalyst);
                if (catalystStack.method_7947() < requiredCount) {
                    lines.add(class_2561.method_43469("text.disenchanter.extra_catalysts_required", requiredCount - catalystStack.method_7947())
                            .method_27692(class_124.field_1061));
                }
            }

            if (catalyst != null) {
                class_310.method_1551().field_1772.method_27527()
                        .method_27495(
                                class_2561.method_43471("disenchanter.catalyst." + stack.method_7909().method_40131().method_40237().method_29177().method_12832()),
                                200,
                                class_2583.field_24360.method_10977(class_124.field_1063)
                        )
                        .stream()
                        .map(VisitableTextContent::new)
                        .map(class_5250::method_43477)
                        .forEach(lines::add);
            }
        });
    }

}
