package com.glisco.disenchanter.compat.rei;

import com.glisco.disenchanter.Disenchanter;
import com.glisco.disenchanter.VisitableTextContent;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import java.util.ArrayList;
import java.util.List;

public class CatalystCategory implements DisplayCategory<CatalystDisplay> {

    @Override
    public Renderer getIcon() {
        return EntryStacks.of(Disenchanter.DISENCHANTER_BLOCK);
    }

    @Override
    public class_2561 getTitle() {
        return class_2561.method_43471("disenchanter.rei.title");
    }

    @Override
    public CategoryIdentifier<? extends CatalystDisplay> getCategoryIdentifier() {
        return DisenchanterReiPlugin.CATALYST;
    }

    @Override
    public List<Widget> setupDisplay(CatalystDisplay display, Rectangle bounds) {
        var widgets = new ArrayList<Widget>();
        var origin = new Point(bounds.x, bounds.y);

        widgets.add(Widgets.createSlot(new Point(origin.x + 5, origin.y - 9 + bounds.height / 2)).markInput().entries(display.getInputEntries().get(0)));

        var catalystName = class_7923.field_41178.method_10221(((class_1799) display.getInputEntries().get(0).get(0).castValue()).method_7909()).method_12832();
        var wrapped = class_310.method_1551().field_1772.method_27527()
                .method_27495(
                        class_2561.method_43471("disenchanter.catalyst." + catalystName),
                        120, class_2583.field_24360
                )
                .stream()
                .map(VisitableTextContent::new)
                .map(class_5250::method_43477)
                .toList();

        int textHeight = wrapped.size() * 10;
        for (int i = 0; i < wrapped.size(); i++) {
            widgets.add(Widgets.createLabel(
                    new Point(origin.x + 25 + (bounds.width - 25) / 2, origin.y - 1 + bounds.height / 2 - textHeight / 2 + i * 10),
                    wrapped.get(i)
            ).color(0x4F4F4F).noShadow());
        }

        return widgets;
    }
}
