/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.disenchanter.catalyst;

import com.glisco.disenchanter.catalyst.Catalyst;
import com.glisco.disenchanter.catalyst.CatalystRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class Catalysts {
    public static void registerDefaults() {
        CatalystRegistry.registerFromConfig(class_1802.field_8687, new Emerald());
        CatalystRegistry.registerFromConfig(class_1802.field_8477, new Diamond());
        CatalystRegistry.registerFromConfig(class_1802.field_8634, new EnderPearl());
        CatalystRegistry.registerFromConfig(class_1802.field_8207, new HeartOfTheSea());
        CatalystRegistry.registerFromConfig(class_1802.field_27063, new AmethystShard());
        CatalystRegistry.registerFromConfig(class_1802.field_8137, new NetherStar());
        CatalystRegistry.registerFromConfig(class_1802.field_8287, new ExperienceBottle());
    }

    public static class Emerald
    implements Catalyst {
        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            class_9304 levelMap = input.method_58657();
            ArrayList enchantments = new ArrayList(levelMap.method_57534());
            for (int i = 0; i < 2 && !enchantments.isEmpty(); ++i) {
                class_6880 addition = (class_6880)enchantments.remove(random.method_43048(enchantments.size()));
                resultStack.method_7978(addition, levelMap.method_57536(addition));
            }
            return resultStack;
        }
    }

    public static class Diamond
    implements Catalyst {
        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            class_9304 levelMap = input.method_58657();
            ArrayList enchantments = new ArrayList(levelMap.method_57534());
            class_6880 enchantment = (class_6880)enchantments.removeFirst();
            resultStack.method_7978(enchantment, levelMap.method_57536(enchantment));
            for (int i = 0; i < 2 && !enchantments.isEmpty(); ++i) {
                class_6880 addition = (class_6880)enchantments.remove(random.method_43048(enchantments.size()));
                resultStack.method_7978(addition, levelMap.method_57536(addition));
            }
            return resultStack;
        }
    }

    public static class EnderPearl
    implements Catalyst {
        @Nullable
        private class_1889 enchantmentCache = null;

        @Override
        public class_1799 transformInput(class_1799 input, class_5819 random) {
            class_9304 levelMap = input.method_58657();
            ArrayList enchantments = new ArrayList(levelMap.method_57534());
            class_6880 removedEnchantment = (class_6880)enchantments.remove(random.method_43048(enchantments.size()));
            this.enchantmentCache = new class_1889(removedEnchantment, levelMap.method_57536(removedEnchantment));
            class_1890.method_57531((class_1799)input, builder -> builder.method_57548(entry -> entry.method_55838(removedEnchantment)));
            int damage = input.method_7919() + 500;
            if (damage >= input.method_7936()) {
                return class_1799.field_8037;
            }
            input.method_7974(damage);
            return input;
        }

        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            if (this.enchantmentCache == null) {
                throw new IllegalStateException();
            }
            resultStack.method_7978(this.enchantmentCache.comp_3486(), this.enchantmentCache.comp_3487());
            this.enchantmentCache = null;
            return resultStack;
        }
    }

    public static class HeartOfTheSea
    implements Catalyst {
        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            HashMap<class_6880, Integer> levelMap = new HashMap<class_6880, Integer>(Map.ofEntries((Map.Entry[])input.method_58657().method_57539().toArray(Map.Entry[]::new)));
            levelMap.forEach((enchantment, integer) -> levelMap.replace((class_6880)enchantment, Math.max(1, integer - 1)));
            levelMap.forEach((arg_0, arg_1) -> ((class_1799)resultStack).method_7978(arg_0, arg_1));
            return resultStack;
        }
    }

    public static class AmethystShard
    implements Catalyst {
        @Override
        public class_1799 transformInput(class_1799 input, class_5819 random) {
            input.method_57379(class_9334.field_49633, (Object)class_9304.field_49385);
            return input;
        }

        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            class_9304 levelMap = input.method_58657();
            class_6880 enchantment = (class_6880)levelMap.method_57534().iterator().next();
            resultStack.method_7978(enchantment, levelMap.method_57536(enchantment));
            return resultStack;
        }
    }

    public static class NetherStar
    implements Catalyst {
        @Override
        public class_1799 transformInput(class_1799 input, class_5819 random) {
            input.method_57379(class_9334.field_49633, (Object)class_9304.field_49385);
            return input;
        }

        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            class_9304 levelMap = input.method_58657();
            levelMap.method_57539().forEach(entry -> resultStack.method_7978((class_6880)entry.getKey(), entry.getIntValue()));
            return resultStack;
        }
    }

    public static class ExperienceBottle
    implements Catalyst {
        @Override
        public class_1799 generateOutput(class_1799 input, class_5819 random) {
            class_1799 resultStack = new class_1799((class_1935)class_1802.field_8598);
            class_9304 levelMap = input.method_58657();
            int maxLevel = levelMap.method_57539().stream().max((o1, o2) -> {
                if (Objects.equals(o1.getIntValue(), o2.getIntValue())) {
                    return 0;
                }
                return o1.getIntValue() > o2.getIntValue() ? 1 : -1;
            }).map(Map.Entry::getValue).orElse(-1);
            levelMap.method_57539().stream().filter(entry -> entry.getIntValue() == maxLevel).forEach(entry -> resultStack.method_7978((class_6880)entry.getKey(), entry.getIntValue()));
            return resultStack;
        }
    }
}

