/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mvs.world.structures;

import com.finndog.mvs.modinit.MVSStructures;
import com.finndog.mvs.utils.GeneralUtils;
import com.finndog.mvs.world.structures.codecs.YRangeAllowance;
import com.finndog.mvs.world.structures.pieces.PieceLimitedJigsawManager;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class GenericJigsawStructure
extends Structure {
    public static final MapCodec<GenericJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GenericJigsawStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)YRangeAllowance.CODEC.optionalFieldOf("y_allowance").forGetter(structure -> structure.yAllowance), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)ResourceLocation.CODEC.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)StringRepresentable.fromEnum(BURYING_TYPE::values).optionalFieldOf("burying_type").forGetter(structure -> structure.buryingType), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, GenericJigsawStructure::new));
    public final Holder<StructureTemplatePool> startPool;
    public final int size;
    public final Optional<YRangeAllowance> yAllowance;
    public final HeightProvider startHeight;
    public final Optional<Heightmap.Types> projectStartToHeightmap;
    public final boolean cannotSpawnInLiquid;
    public final Optional<Integer> terrainHeightCheckRadius;
    public final Optional<Integer> allowedTerrainHeightRange;
    public final Optional<Integer> biomeRadius;
    public final HashSet<ResourceLocation> poolsThatIgnoreBoundaries;
    public final Optional<Integer> maxDistanceFromCenter;
    public final Optional<BURYING_TYPE> buryingType;
    public final boolean useBoundingBoxHack;
    public final LiquidSettings liquidSettings;

    public GenericJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<YRangeAllowance> yAllowance, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, HashSet<ResourceLocation> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<BURYING_TYPE> buryingType, boolean useBoundingBoxHack, LiquidSettings liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.size = size;
        this.yAllowance = yAllowance;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.cannotSpawnInLiquid = cannotSpawnInLiquid;
        this.terrainHeightCheckRadius = terrainHeightCheckRadius;
        this.allowedTerrainHeightRange = allowedTerrainHeightRange;
        this.biomeRadius = biomeRadius;
        this.poolsThatIgnoreBoundaries = poolsThatIgnoreBoundaries;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.buryingType = buryingType;
        this.useBoundingBoxHack = useBoundingBoxHack;
        this.liquidSettings = liquidSettings;
        if (yAllowance.isPresent() && yAllowance.get().maxYAllowed.isPresent() && yAllowance.get().minYAllowed.isPresent() && yAllowance.get().maxYAllowed.get() < yAllowance.get().minYAllowed.get()) {
            throw new RuntimeException("    Moog's Voyager Structures: maxYAllowed cannot be less than minYAllowed.\n    Please correct this error as there's no way to spawn this structure properly\n        Structure pool of problematic structure: %s\n".formatted(startPool.value()));
        }
    }

    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        ChunkPos chunkPos = context.chunkPos();
        if (this.biomeRadius.isPresent() && !(context.biomeSource() instanceof CheckerboardColumnBiomeSource)) {
            int validBiomeRange = this.biomeRadius.get();
            int sectionY = blockPos.getY();
            if (this.projectStartToHeightmap.isPresent()) {
                sectionY += context.chunkGenerator().getFirstOccupiedHeight(blockPos.getX(), blockPos.getZ(), this.projectStartToHeightmap.get(), context.heightAccessor(), context.randomState());
            }
            sectionY = QuartPos.fromBlock((int)sectionY);
            for (int curChunkX = chunkPos.x - validBiomeRange; curChunkX <= chunkPos.x + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.z - validBiomeRange; curChunkZ <= chunkPos.z + validBiomeRange; ++curChunkZ) {
                    Holder biome = context.biomeSource().getNoiseBiome(QuartPos.fromSection((int)curChunkX), sectionY, QuartPos.fromSection((int)curChunkZ), context.randomState().sampler());
                    if (context.validBiome().test(biome)) continue;
                    return false;
                }
            }
        }
        if (this.cannotSpawnInLiquid) {
            BlockPos centerOfChunk = chunkPos.getMiddleBlockPosition(0);
            int landHeight = context.chunkGenerator().getFirstOccupiedHeight(centerOfChunk.getX(), centerOfChunk.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
            NoiseColumn columnOfBlocks = context.chunkGenerator().getBaseColumn(centerOfChunk.getX(), centerOfChunk.getZ(), context.heightAccessor(), context.randomState());
            BlockState topBlock = columnOfBlocks.getBlock(centerOfChunk.getY() + landHeight);
            if (!topBlock.getFluidState().isEmpty()) {
                return false;
            }
        }
        if (this.terrainHeightCheckRadius.isPresent() && (this.allowedTerrainHeightRange.isPresent() || this.yAllowance.isPresent() && this.yAllowance.get().minYAllowed.isPresent())) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            int terrainCheckRange = this.terrainHeightCheckRadius.get();
            for (int curChunkX = chunkPos.x - terrainCheckRange; curChunkX <= chunkPos.x + terrainCheckRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.z - terrainCheckRange; curChunkZ <= chunkPos.z + terrainCheckRange; ++curChunkZ) {
                    int height = context.chunkGenerator().getBaseHeight((curChunkX << 4) + 7, (curChunkZ << 4) + 7, this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG), context.heightAccessor(), context.randomState());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                    if (this.yAllowance.isPresent() && this.yAllowance.get().minYAllowed.isPresent() && minTerrainHeight < this.yAllowance.get().minYAllowed.get()) {
                        return false;
                    }
                    if (!this.yAllowance.isPresent() || !this.yAllowance.get().maxYAllowed.isPresent() || minTerrainHeight <= this.yAllowance.get().maxYAllowed.get()) continue;
                    return false;
                }
            }
            if (this.allowedTerrainHeightRange.isPresent() && maxTerrainHeight - minTerrainHeight > this.allowedTerrainHeightRange.get()) {
                return false;
            }
        }
        return true;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int offsetY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        BlockPos blockpos = new BlockPos(context.chunkPos().getMinBlockX(), offsetY, context.chunkPos().getMinBlockZ());
        if (!this.extraSpawningChecks(context, blockpos)) {
            return Optional.empty();
        }
        int topClipOff = Integer.MAX_VALUE;
        int bottomClipOff = Integer.MIN_VALUE;
        if (this.yAllowance.isPresent()) {
            if (this.yAllowance.get().maxYAllowed.isPresent()) {
                topClipOff = Math.min(topClipOff, this.yAllowance.get().maxYAllowed.get());
            }
            if (this.yAllowance.get().minYAllowed.isPresent()) {
                bottomClipOff = Math.max(bottomClipOff, this.yAllowance.get().minYAllowed.get());
            }
        }
        int finalTopClipOff = topClipOff;
        int finalBottomClipOff = bottomClipOff;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, this.startPool, this.size, context.registryAccess().lookupOrThrow(Registries.STRUCTURE).getKey((Object)this), blockpos, this.useBoundingBoxHack, this.projectStartToHeightmap, topClipOff, bottomClipOff, this.poolsThatIgnoreBoundaries, this.maxDistanceFromCenter, this.buryingType, this.liquidSettings, (structurePiecesBuilder, pieces) -> this.postLayoutAdjustments((StructurePiecesBuilder)structurePiecesBuilder, context, offsetY, blockpos, finalTopClipOff, finalBottomClipOff, (List<PoolElementStructurePiece>)pieces));
    }

    protected void postLayoutAdjustments(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context, int offsetY, BlockPos blockpos, int topClipOff, int bottomClipOff, List<PoolElementStructurePiece> pieces) {
        GeneralUtils.centerAllPieces(blockpos, pieces);
        if (this.buryingType.isEmpty()) {
            return;
        }
        if (this.buryingType.get() == BURYING_TYPE.LOWEST_CORNER) {
            Heightmap.Types heightMapToUse = this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG);
            BoundingBox box = pieces.get(0).getBoundingBox();
            int highestLandPos = context.chunkGenerator().getFirstOccupiedHeight(box.minX(), box.minZ(), heightMapToUse, context.heightAccessor(), context.randomState());
            highestLandPos = Math.min(highestLandPos, context.chunkGenerator().getFirstOccupiedHeight(box.minX(), box.maxZ(), heightMapToUse, context.heightAccessor(), context.randomState()));
            highestLandPos = Math.min(highestLandPos, context.chunkGenerator().getFirstOccupiedHeight(box.maxX(), box.minZ(), heightMapToUse, context.heightAccessor(), context.randomState()));
            highestLandPos = Math.min(highestLandPos, context.chunkGenerator().getFirstOccupiedHeight(box.maxX(), box.maxZ(), heightMapToUse, context.heightAccessor(), context.randomState()));
            if (!(this.cannotSpawnInLiquid || heightMapToUse != Heightmap.Types.OCEAN_FLOOR_WG && heightMapToUse != Heightmap.Types.OCEAN_FLOOR)) {
                int maxHeightForSubmerging = context.chunkGenerator().getSeaLevel() - box.getYSpan();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            } else {
                highestLandPos = Math.max(highestLandPos, context.chunkGenerator().getSeaLevel());
            }
            this.offsetToNewHeight(context, offsetY, pieces, box, highestLandPos);
        } else if (this.buryingType.get() == BURYING_TYPE.AVERAGE_LAND) {
            int maxYAllowed;
            int minYAllowed;
            BoundingBox box = pieces.get(0).getBoundingBox();
            BlockPos centerPos = new BlockPos((Vec3i)box.getCenter());
            int radius = (int)Math.sqrt(box.getLength().getX() * box.getLength().getX() + box.getLength().getZ() * box.getLength().getZ()) / 2;
            Heightmap.Types heightMapToUse = this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG);
            ArrayList<Integer> landHeights = new ArrayList<Integer>();
            for (int xOffset = -radius; xOffset <= radius; xOffset += radius / 2) {
                for (int zOffset = -radius; zOffset <= radius; zOffset += radius / 2) {
                    int landHeight = context.chunkGenerator().getFirstOccupiedHeight(centerPos.getX() + xOffset, centerPos.getZ() + zOffset, heightMapToUse, context.heightAccessor(), context.randomState());
                    landHeights.add(landHeight);
                }
            }
            if (this.yAllowance.isPresent()) {
                minYAllowed = this.yAllowance.get().minYAllowed.orElse(Integer.MIN_VALUE);
                maxYAllowed = this.yAllowance.get().maxYAllowed.orElse(Integer.MAX_VALUE);
            } else {
                maxYAllowed = Integer.MAX_VALUE;
                minYAllowed = Integer.MIN_VALUE;
            }
            OptionalDouble avgHeightOptional = landHeights.stream().filter(height -> height > minYAllowed && height < maxYAllowed).mapToInt(Integer::intValue).average();
            if (this.yAllowance.isPresent()) {
                if (this.yAllowance.get().maxYAllowed.isPresent() && avgHeightOptional.isEmpty()) {
                    avgHeightOptional = OptionalDouble.of(this.yAllowance.get().maxYAllowed.get().intValue());
                }
                if (this.yAllowance.get().minYAllowed.isPresent() && avgHeightOptional.isEmpty()) {
                    avgHeightOptional = OptionalDouble.of(this.yAllowance.get().minYAllowed.get().intValue());
                }
            }
            if (avgHeightOptional.isPresent()) {
                double avgHeight = avgHeightOptional.getAsDouble();
                if (this.cannotSpawnInLiquid && heightMapToUse != Heightmap.Types.OCEAN_FLOOR_WG && heightMapToUse != Heightmap.Types.OCEAN_FLOOR) {
                    avgHeight = Math.max(avgHeight, (double)context.chunkGenerator().getSeaLevel());
                    if (this.yAllowance.isPresent() && this.yAllowance.get().maxYAllowed.isPresent()) {
                        avgHeight = Math.max(avgHeight, (double)this.yAllowance.get().maxYAllowed.get().intValue());
                    }
                }
                int parentHeight = pieces.get(0).getBoundingBox().minY();
                int offsetAmount = (int)avgHeight - parentHeight + offsetY;
                pieces.forEach(child -> child.move(0, offsetAmount, 0));
            } else {
                pieces.clear();
            }
        } else if (this.buryingType.get() == BURYING_TYPE.LOWEST_SIDE) {
            Heightmap.Types heightMapToUse = this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG);
            BoundingBox box = pieces.get(0).getBoundingBox();
            BlockPos centerPos = box.getCenter();
            int highestLandPos = Integer.MAX_VALUE;
            Optional<Integer> minYAllowed = Optional.empty();
            if (this.yAllowance.isPresent()) {
                minYAllowed = this.yAllowance.get().minYAllowed;
            }
            highestLandPos = this.terrainHeight(context, heightMapToUse, box.minX(), centerPos.getZ(), minYAllowed, highestLandPos);
            highestLandPos = this.terrainHeight(context, heightMapToUse, centerPos.getX(), box.maxZ(), minYAllowed, highestLandPos);
            highestLandPos = this.terrainHeight(context, heightMapToUse, centerPos.getX(), box.minZ(), minYAllowed, highestLandPos);
            highestLandPos = this.terrainHeight(context, heightMapToUse, box.maxX(), centerPos.getZ(), minYAllowed, highestLandPos);
            if (minYAllowed.isPresent() && highestLandPos == Integer.MAX_VALUE) {
                highestLandPos = minYAllowed.get();
            }
            if (!(this.cannotSpawnInLiquid || heightMapToUse != Heightmap.Types.OCEAN_FLOOR_WG && heightMapToUse != Heightmap.Types.OCEAN_FLOOR)) {
                int maxHeightForSubmerging = context.chunkGenerator().getSeaLevel() - box.getYSpan();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            } else {
                highestLandPos = Math.max(highestLandPos, context.chunkGenerator().getSeaLevel());
            }
            this.offsetToNewHeight(context, offsetY, pieces, box, highestLandPos);
        }
    }

    private int terrainHeight(Structure.GenerationContext context, Heightmap.Types heightMapToUse, int x, int z, Optional<Integer> minYAllowed, int highestLandPos) {
        int landPos = context.chunkGenerator().getFirstOccupiedHeight(x, z, heightMapToUse, context.heightAccessor(), context.randomState());
        if (minYAllowed.isPresent()) {
            if (landPos >= minYAllowed.get()) {
                highestLandPos = landPos;
            }
        } else {
            highestLandPos = Math.min(highestLandPos, landPos);
        }
        return highestLandPos;
    }

    private void offsetToNewHeight(Structure.GenerationContext context, int offsetY, List<PoolElementStructurePiece> pieces, BoundingBox box, int highestLandPos) {
        if (this.yAllowance.isPresent()) {
            if (this.yAllowance.get().maxYAllowed.isPresent() && box.maxY() + offsetY < this.yAllowance.get().minYAllowed.get()) {
                highestLandPos = Math.max(highestLandPos, this.yAllowance.get().maxYAllowed.get());
            }
            if (this.yAllowance.get().minYAllowed.isPresent() && box.minY() + offsetY < this.yAllowance.get().minYAllowed.get()) {
                highestLandPos = Math.min(highestLandPos, this.yAllowance.get().minYAllowed.get());
            }
        }
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.setLargeFeatureSeed(context.seed(), context.chunkPos().x, context.chunkPos().z);
        int heightDiff = highestLandPos - box.minY();
        for (StructurePiece structurePiece : pieces) {
            structurePiece.move(0, heightDiff + offsetY, 0);
        }
    }

    public StructureType<?> type() {
        return MVSStructures.GENERIC_JIGSAW_STRUCTURE.get();
    }

    public static enum BURYING_TYPE implements StringRepresentable
    {
        LOWEST_CORNER("LOWEST_CORNER"),
        AVERAGE_LAND("AVERAGE_LAND"),
        LOWEST_SIDE("LOWEST_SIDE");

        private final String name;
        private static final Map<String, BURYING_TYPE> BY_NAME;

        private BURYING_TYPE(String name) {
            this.name = name;
        }

        public static BURYING_TYPE byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_NAME = (Map)Util.make((Object)Maps.newHashMap(), hashMap -> {
                BURYING_TYPE[] var1;
                for (BURYING_TYPE type : var1 = BURYING_TYPE.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

