/*
 * Decompiled with CFR 0.152.
 */
package net.mattwhyy.onemace;

import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.mattwhyy.onemace.OneMaceCommand;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class OneMace
extends JavaPlugin
implements Listener {
    private boolean maceCrafted;
    private final NamespacedKey maceKey = new NamespacedKey((Plugin)this, "mace-tracker");
    private final Set<UUID> trackedDestroyedItems = new HashSet<UUID>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.updateConfig();
        this.maceCrafted = this.getConfig().getBoolean("settings.mace-crafted", false);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (!this.doesMaceExist()) {
                this.resetMaceCrafting(false);
                this.getConfig().set("offline_inventory", null);
                this.saveConfig();
            } else {
                this.removeAllMaceRecipes();
                this.getLogger().info("[OneMace] Mace already crafted. Recipes removed.");
            }
        }, 40L);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("onemace").setExecutor((CommandExecutor)new OneMaceCommand(this));
        this.getLogger().info("[OneMace] Plugin enabled!");
    }

    public void updateConfig() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        if (!this.getConfig().contains("messages.crafted")) {
            this.getConfig().set("messages.crafted", (Object)"&b[OneMace] &eThe Mace has been crafted!");
        }
        if (!this.getConfig().contains("messages.lost")) {
            this.getConfig().set("messages.lost", (Object)"&b[OneMace] &eThe Mace has been lost!");
        }
        if (!this.getConfig().contains("settings.allow-locate-for-all")) {
            this.getConfig().set("settings.allow-locate-for-all", (Object)false);
        }
        if (!this.getConfig().contains("settings.colored-name")) {
            this.getConfig().set("settings.colored-name", (Object)false);
        }
        if (!this.getConfig().contains("settings.mace-name-color")) {
            this.getConfig().set("settings.mace-name-color", (Object)"RED");
        }
        this.saveConfig();
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        boolean hasMace = false;
        for (ItemStack item : player.getInventory().getContents()) {
            if (!this.isMace(item)) continue;
            hasMace = true;
            break;
        }
        for (ItemStack item : player.getEnderChest().getContents()) {
            if (!this.isMace(item)) continue;
            hasMace = true;
            this.getLogger().info("[OneMace] Player " + player.getName() + " logged out with the Mace in their Ender Chest.");
            break;
        }
        if (this.isMaceOwner(player.getUniqueId())) {
            this.saveMaceOwner(null);
        }
        this.getConfig().set("offline_inventory." + player.getUniqueId().toString(), (Object)hasMace);
        this.saveConfig();
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        for (ItemStack drop : event.getDrops()) {
            if (!this.isMace(drop)) continue;
            this.saveMaceOwner(null);
            break;
        }
    }

    public void onDisable() {
        this.getLogger().info("[OneMace] Saving Ender Chest data before shutdown...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean hasMace = false;
            for (ItemStack item : player.getInventory().getContents()) {
                if (!this.isMace(item)) continue;
                hasMace = true;
                break;
            }
            for (ItemStack item : player.getEnderChest().getContents()) {
                if (!this.isMace(item)) continue;
                hasMace = true;
                this.getLogger().info("[OneMace] Player " + player.getName() + " had the Mace in their Ender Chest before shutdown.");
                break;
            }
            this.getConfig().set("offline_inventory." + player.getUniqueId().toString(), (Object)hasMace);
        }
        this.saveConfig();
        this.getLogger().info("[OneMace] Plugin disabled! Ender Chest data saved.");
    }

    public void removeAllMaceRecipes() {
        NamespacedKey vanillaMaceKey = NamespacedKey.minecraft((String)"mace");
        if (Bukkit.getRecipe((NamespacedKey)vanillaMaceKey) != null) {
            Bukkit.removeRecipe((NamespacedKey)vanillaMaceKey);
            this.getLogger().info("[OneMace] Removed vanilla Mace recipe.");
        }
    }

    private boolean isAllowedContainer(InventoryType type) {
        return type == InventoryType.ENDER_CHEST || type == InventoryType.ANVIL || type == InventoryType.ENCHANTING;
    }

    @EventHandler
    public void onMaceDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        Item droppedItem = event.getItemDrop();
        if (this.isMace(droppedItem.getItemStack())) {
            this.saveMaceOwner(null);
            this.getLogger().info("[OneMace] Mace ownership cleared due to drop.");
            this.getConfig().set("offline_inventory." + player.getUniqueId().toString(), (Object)false);
            this.saveConfig();
        }
    }

    @EventHandler
    public void onMacePickup(EntityPickupItemEvent event) {
        ItemStack pickedItem = event.getItem().getItemStack();
        if (this.isMace(pickedItem)) {
            if (event.getEntity() instanceof Player) {
                this.saveMaceOwner(event.getEntity().getUniqueId());
            } else {
                this.saveMaceOwner(null);
            }
        }
    }

    @EventHandler
    public void onMaceMove(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            ItemStack hotbarItem;
            int hotbarSlot;
            Player player = (Player)event.getWhoClicked();
            ItemStack cursorItem = event.getCursor();
            ItemStack clickedItem = event.getCurrentItem();
            if (event.getClick() == ClickType.NUMBER_KEY && (hotbarSlot = event.getHotbarButton()) >= 0 && this.isMace(hotbarItem = player.getInventory().getItem(hotbarSlot)) && !this.isAllowedContainer(event.getInventory().getType())) {
                event.setCancelled(true);
                return;
            }
            if (this.isMace(cursorItem)) {
                this.saveMaceOwner(player.getUniqueId());
                this.getConfig().set("offline_inventory." + player.getUniqueId().toString(), (Object)false);
                this.saveConfig();
                if (!this.isAllowedContainer(event.getInventory().getType())) {
                    event.setCancelled(true);
                    return;
                }
            } else if (this.isMace(clickedItem) && (this.isStorageContainer(event.getInventory().getType()) || this.isAnimalStorage(event))) {
                if (!this.isAllowedContainer(event.getInventory().getType())) {
                    event.setCancelled(true);
                } else {
                    this.saveMaceOwner(null);
                }
            }
        }
    }

    private boolean isStorageContainer(InventoryType type) {
        return type == InventoryType.CHEST || type == InventoryType.ENDER_CHEST || type == InventoryType.BARREL || type == InventoryType.DROPPER || type == InventoryType.DISPENSER || type == InventoryType.SHULKER_BOX || type == InventoryType.CRAFTER || type == InventoryType.HOPPER || type == InventoryType.ANVIL || type == InventoryType.ENCHANTING;
    }

    private boolean isAnimalStorage(InventoryClickEvent event) {
        return event.getInventory().getHolder() instanceof AbstractHorse;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID playerUUID = event.getPlayer().getUniqueId();
        this.getConfig().set("offline_inventory." + playerUUID.toString(), null);
        this.saveConfig();
        if (!this.doesMaceExist()) {
            this.resetMaceCrafting(false);
        }
        if (this.isMaceOwner(playerUUID)) {
            this.updateMaceNameColor(playerUUID);
        }
    }

    public void markMace(ItemStack mace) {
        ItemMeta meta = mace.getItemMeta();
        if (meta != null) {
            PersistentDataContainer data = meta.getPersistentDataContainer();
            data.set(this.maceKey, PersistentDataType.STRING, (Object)"true");
            mace.setItemMeta(meta);
        }
    }

    public boolean isMace(ItemStack item) {
        try {
            if (item == null || item.getType() != Material.MACE || !item.hasItemMeta()) {
                return false;
            }
            ItemMeta meta = item.getItemMeta();
            PersistentDataContainer data = meta.getPersistentDataContainer();
            return data.has(this.maceKey, PersistentDataType.STRING);
        }
        catch (Exception e) {
            return false;
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        if (event.getRecipe() != null && event.getRecipe().getResult().getType() == Material.MACE && this.maceCrafted) {
            event.getInventory().setResult(null);
        }
    }

    @EventHandler
    public void onCraft(CraftItemEvent event) {
        if (event.getRecipe() != null && event.getRecipe().getResult().getType() == Material.MACE) {
            if (this.maceCrafted) {
                event.setCancelled(true);
                return;
            }
            this.maceCrafted = true;
            this.getConfig().set("settings.mace-crafted", (Object)true);
            this.saveMaceOwner(event.getWhoClicked().getUniqueId());
            this.saveConfig();
            ItemStack mace = event.getInventory().getResult();
            if (mace != null) {
                this.markMace(mace);
            }
            Bukkit.getScheduler().runTask((Plugin)this, this::removeAllMaceRecipes);
            this.getLogger().info("[OneMace] Mace crafted! Removing recipe.");
            if (this.getConfig().getBoolean("settings.announce-mace-messages", true)) {
                String craftedMessage = this.getConfig().getString("messages.crafted", "&b[OneMace] The Mace has been crafted!");
                Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)craftedMessage));
            }
        }
    }

    @EventHandler
    public void onCrafterCraft(CrafterCraftEvent event) {
        if (event.getRecipe().getResult().getType() == Material.MACE) {
            event.setCancelled(true);
        }
    }

    private boolean doesMaceExist() {
        this.getLogger().info("[OneMace] Checking if Mace exists...");
        boolean maceFound = false;
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (ItemStack itemStack : player.getInventory().getContents()) {
                if (!this.isMace(itemStack) && !this.isMaceInsideShulker(itemStack)) continue;
                this.getLogger().info("[OneMace] Mace found in " + player.getName() + "'s inventory.");
                return true;
            }
            for (ItemStack itemStack : player.getEnderChest().getContents()) {
                if (!this.isMace(itemStack) && !this.isMaceInsideShulker(itemStack)) continue;
                this.getLogger().info("[OneMace] Mace found in " + player.getName() + "'s Ender Chest.");
                return true;
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                Item item;
                if (!(entity instanceof Item) || !this.isMace((item = (Item)entity).getItemStack()) && !this.isMaceInsideShulker(item.getItemStack())) continue;
                this.getLogger().info("[OneMace] Mace found as a dropped item in world: " + world.getName());
                return true;
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                BlockState[] blockStateArray = chunk.getTileEntities();
                int n = blockStateArray.length;
                for (int i = 0; i < n; ++i) {
                    BlockState state = blockStateArray[i];
                    if (!(state instanceof Container)) continue;
                    Container container = (Container)state;
                    Inventory inv = container.getInventory();
                    for (ItemStack item : inv.getContents()) {
                        if (!this.isMace(item) && !this.isMaceInsideShulker(item)) continue;
                        this.getLogger().info("[OneMace] Mace found inside a container at " + String.valueOf(state.getLocation()));
                        return true;
                    }
                }
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (entity instanceof AbstractHorse) {
                    AbstractHorse horse = (AbstractHorse)entity;
                    for (ItemStack item : horse.getInventory().getContents()) {
                        if (!this.isMace(item) && !this.isMaceInsideShulker(item)) continue;
                        this.getLogger().info("[OneMace] Mace found in a horse inventory!");
                        return true;
                    }
                }
                if (entity instanceof StorageMinecart) {
                    StorageMinecart minecart = (StorageMinecart)entity;
                    for (ItemStack item : minecart.getInventory().getContents()) {
                        if (!this.isMace(item) && !this.isMaceInsideShulker(item)) continue;
                        this.getLogger().info("[OneMace] Mace found in a storage minecart!");
                        return true;
                    }
                }
                if (!(entity instanceof ChestBoat)) continue;
                ChestBoat chestBoat = (ChestBoat)entity;
                for (ItemStack item : chestBoat.getInventory().getContents()) {
                    if (!this.isMace(item) && !this.isMaceInsideShulker(item)) continue;
                    this.getLogger().info("[OneMace] Mace found in a Chest Boat at X: " + entity.getLocation().getBlockX() + " Y: " + entity.getLocation().getBlockY() + " Z: " + entity.getLocation().getBlockZ() + " in world " + entity.getWorld().getName());
                    return true;
                }
            }
        }
        if (this.getConfig().isConfigurationSection("offline_inventory")) {
            for (String uuid : this.getConfig().getConfigurationSection("offline_inventory").getKeys(true)) {
                if (!this.getConfig().getBoolean("offline_inventory." + uuid, true)) continue;
                this.getLogger().info("[OneMace] Mace is in an offline player's inventory (UUID: " + uuid + ").");
                return true;
            }
        }
        this.getLogger().info("[OneMace] Mace does not exist! Crafting can be re-enabled.");
        this.getConfig().set("offline_inventory", null);
        this.saveConfig();
        return false;
    }

    private boolean isMaceInsideShulker(ItemStack item) {
        BlockState blockState;
        if (item == null || item.getType() != Material.SHULKER_BOX) {
            return false;
        }
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        if (meta == null || !((blockState = meta.getBlockState()) instanceof ShulkerBox)) {
            return false;
        }
        ShulkerBox shulkerBox = (ShulkerBox)blockState;
        Inventory shulkerInv = shulkerBox.getInventory();
        for (ItemStack storedItem : shulkerInv.getContents()) {
            if (!this.isMace(storedItem) && !this.isMaceInsideShulker(storedItem)) continue;
            return true;
        }
        return false;
    }

    private void updateMaceNameColor(UUID ownerUUID) {
        Player player;
        if (!this.getConfig().getBoolean("settings.colored-name", true)) {
            return;
        }
        Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
        Team maceTeam = board.getTeam("maceHolder");
        if (maceTeam == null) {
            maceTeam = board.registerNewTeam("maceHolder");
        }
        maceTeam.getEntries().forEach(arg_0 -> ((Team)maceTeam).removeEntry(arg_0));
        if (ownerUUID != null && (player = Bukkit.getPlayer((UUID)ownerUUID)) != null) {
            String colorName = this.getConfig().getString("settings.mace-name-color", "RED").toUpperCase();
            try {
                ChatColor color = ChatColor.valueOf((String)colorName);
                maceTeam.setColor(color);
            }
            catch (IllegalArgumentException e) {
                maceTeam.setColor(ChatColor.RED);
            }
            maceTeam.addEntry(player.getName());
            this.getLogger().info("[OneMace] Applied colored name to mace holder " + player.getName());
        }
    }

    public void saveMaceOwner(UUID ownerUUID) {
        if (ownerUUID == null) {
            this.getConfig().set("settings.mace-owner", null);
        } else {
            this.getConfig().set("settings.mace-owner", (Object)ownerUUID.toString());
        }
        this.saveConfig();
        this.updateMaceNameColor(ownerUUID);
    }

    public UUID getMaceOwner() {
        String ownerUUID = this.getConfig().getString("settings.mace-owner");
        return ownerUUID != null ? UUID.fromString(ownerUUID) : null;
    }

    public boolean isMaceOwner(UUID playerUUID) {
        UUID maceOwner = this.getMaceOwner();
        return maceOwner != null && maceOwner.equals(playerUUID);
    }

    public void resetMaceCrafting(boolean announce) {
        this.maceCrafted = false;
        this.getConfig().set("settings.mace-crafted", (Object)false);
        this.getConfig().set("offline_inventory", null);
        this.saveConfig();
        this.addVanillaMaceRecipe();
        this.getLogger().info("[OneMace] No Mace found. Crafting is re-enabled.");
        if (announce && this.getConfig().getBoolean("settings.announce-mace-messages", true)) {
            String lostMessage = this.getConfig().getString("messages.lost", "&b[OneMace] The Mace has been lost!");
            Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)lostMessage));
        }
    }

    private void addVanillaMaceRecipe() {
        NamespacedKey vanillaMaceKey = NamespacedKey.minecraft((String)"mace");
        if (Bukkit.getRecipe((NamespacedKey)vanillaMaceKey) == null) {
            Bukkit.reloadData();
            this.getLogger().info("[OneMace] Vanilla Mace recipe has been restored.");
        }
    }

    @EventHandler
    public void onMaceBreak(PlayerItemBreakEvent event) {
        ItemStack brokenItem = event.getBrokenItem();
        if (this.isMace(brokenItem)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (!this.doesMaceExist()) {
                    this.resetMaceCrafting(true);
                }
            }, 50L);
        }
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        if (this.isMace(event.getEntity().getItemStack())) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (!this.doesMaceExist()) {
                    this.resetMaceCrafting(true);
                }
            }, 50L);
        }
    }

    @EventHandler
    public void onItemRemoved(EntityRemoveFromWorldEvent event) {
        Item item;
        Entity entity = event.getEntity();
        if (entity instanceof Item && this.isMace((item = (Item)entity).getItemStack())) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (!this.doesMaceExist()) {
                    this.resetMaceCrafting(true);
                }
            }, 50L);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() != Material.MACE) {
            return;
        }
        if (block.getType() == Material.DECORATED_POT) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() != Material.MACE) {
            return;
        }
        if (entity instanceof ItemFrame) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBundleStore(InventoryClickEvent event) {
        Inventory topInventory;
        if (event.getClickedInventory() == null) {
            return;
        }
        Inventory clickedInventory = event.getClickedInventory();
        ItemStack cursorItem = event.getCursor();
        ItemStack clickedItem = event.getCurrentItem();
        if (cursorItem == null || clickedItem == null) {
            return;
        }
        if ((clickedInventory != null && clickedInventory.getType() == InventoryType.SHULKER_BOX || clickedInventory.getType() == InventoryType.HOPPER) && (this.isMace(cursorItem) || this.isMace(clickedItem))) {
            event.setCancelled(true);
        }
        if (event.isShiftClick() && this.isMace(clickedItem) && ((topInventory = event.getView().getTopInventory()).getType() == InventoryType.SHULKER_BOX || topInventory.getType() == InventoryType.HOPPER)) {
            event.setCancelled(true);
        }
        if (this.isMace(cursorItem) && this.isBundle(clickedItem) || this.isBundle(cursorItem) && this.isMace(clickedItem)) {
            event.setCancelled(true);
        }
        if (event.isShiftClick() && this.isMace(clickedItem) && event.getInventory().getType() == InventoryType.PLAYER) {
            for (ItemStack item : event.getWhoClicked().getInventory().getContents()) {
                if (!this.isBundle(item)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onHopperMove(InventoryMoveItemEvent event) {
        ItemStack item = event.getItem();
        if (this.isMace(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onHopperPickup(InventoryPickupItemEvent event) {
        Item item = event.getItem();
        if (this.isMace(item.getItemStack())) {
            event.setCancelled(true);
        }
    }

    private boolean isBundle(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        return type == Material.BUNDLE || type.name().endsWith("_BUNDLE");
    }
}

