/*
 * Decompiled with CFR 0.152.
 */
package net.mattwhyy.onemace;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.mattwhyy.onemace.OneMace;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class OneMaceCommand
implements CommandExecutor {
    private final OneMace plugin;

    public OneMaceCommand(OneMace plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /onemace <locate> | <info> | <fix>");
            return true;
        }
        if (args[0].equalsIgnoreCase("locate")) {
            boolean allowAll = this.plugin.getConfig().getBoolean("settings.allow-locate-for-all", false);
            if (!allowAll && !sender.hasPermission("onemace.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Locating the Mace...");
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.locateMace(sender));
            return true;
        }
        if (args[0].equalsIgnoreCase("fix")) {
            if (!sender.hasPermission("onemace.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                return true;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.fixDuplicateMaces(sender));
            return true;
        }
        if (args[0].equalsIgnoreCase("info")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Ensuring only one Mace exists on the server.");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "If the Mace is destroyed, crafting is restored.");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Use /onemace locate to manually verify Mace status.");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Use /onemace fix to remove duplicate Maces.");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "If you need support, feel free to message me on Discord.");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "made by mattwhyy <3");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid subcommand. Use /onemace <locate> | <info> | <fix>");
        return true;
    }

    private void fixDuplicateMaces(CommandSender sender) {
        int n;
        ArrayList<Object> foundMaces = new ArrayList<Object>();
        ArrayList<ItemStack> duplicates = new ArrayList<ItemStack>();
        UUID maceOwner = this.plugin.getMaceOwner();
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Running Mace scan...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (ItemStack itemStack : player.getInventory().getContents()) {
                if (this.isAnyMace(itemStack)) {
                    foundMaces.add(itemStack);
                    continue;
                }
                if (!this.isMaceInsideShulker(itemStack)) continue;
                foundMaces.addAll(this.getMacesFromShulker(itemStack));
            }
            for (ItemStack itemStack : player.getEnderChest().getContents()) {
                if (this.isAnyMace(itemStack)) {
                    foundMaces.add(itemStack);
                    continue;
                }
                if (!this.isMaceInsideShulker(itemStack)) continue;
                foundMaces.addAll(this.getMacesFromShulker(itemStack));
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof AbstractHorse)) continue;
                AbstractHorse horse = (AbstractHorse)entity;
                ItemStack[] itemStackArray = horse.getInventory().getContents();
                int n2 = itemStackArray.length;
                for (n = 0; n < n2; ++n) {
                    ItemStack item2 = itemStackArray[n];
                    if (this.isAnyMace(item2)) {
                        foundMaces.add(item2);
                        continue;
                    }
                    if (!this.isMaceInsideShulker(item2)) continue;
                    foundMaces.addAll(this.getMacesFromShulker(item2));
                }
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Item)) continue;
                Item item = (Item)entity;
                ItemStack itemStack = item.getItemStack();
                if (this.isAnyMace(itemStack)) {
                    foundMaces.add(itemStack);
                    continue;
                }
                if (!this.isMaceInsideShulker(itemStack)) continue;
                foundMaces.addAll(this.getMacesFromShulker(itemStack));
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                BlockState[] blockStateArray = chunk.getTileEntities();
                n = blockStateArray.length;
                for (int item2 = 0; item2 < n; ++item2) {
                    BlockState state = blockStateArray[item2];
                    if (!(state instanceof Container)) continue;
                    Container container = (Container)state;
                    for (ItemStack item : container.getInventory().getContents()) {
                        if (this.isAnyMace(item)) {
                            foundMaces.add(item);
                            continue;
                        }
                        if (!this.isMaceInsideShulker(item)) continue;
                        foundMaces.addAll(this.getMacesFromShulker(item));
                    }
                }
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (entity instanceof StorageMinecart) {
                    StorageMinecart minecart = (StorageMinecart)entity;
                    for (ItemStack item : minecart.getInventory().getContents()) {
                        if (this.isAnyMace(item)) {
                            foundMaces.add(item);
                            continue;
                        }
                        if (!this.isMaceInsideShulker(item)) continue;
                        foundMaces.addAll(this.getMacesFromShulker(item));
                    }
                }
                if (!(entity instanceof ChestBoat)) continue;
                ChestBoat chestBoat = (ChestBoat)entity;
                for (ItemStack item : chestBoat.getInventory().getContents()) {
                    if (this.isAnyMace(item)) {
                        foundMaces.add(item);
                        continue;
                    }
                    if (!this.isMaceInsideShulker(item)) continue;
                    foundMaces.addAll(this.getMacesFromShulker(item));
                }
            }
        }
        if (foundMaces.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "No Mace found. Enabling crafting.");
            this.plugin.resetMaceCrafting(true);
            return;
        }
        ItemStack officialMace = (ItemStack)foundMaces.get(0);
        this.plugin.markMace(officialMace);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed all duplicate Maces (if they existed).");
        for (int i = 1; i < foundMaces.size(); ++i) {
            duplicates.add((ItemStack)foundMaces.get(i));
        }
        for (ItemStack duplicate : duplicates) {
            duplicate.setAmount(0);
        }
        this.plugin.getConfig().set("settings.mace-crafted", (Object)true);
        this.plugin.saveConfig();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, this.plugin::removeAllMaceRecipes);
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Recipe removed to prevent further crafting.");
    }

    private boolean isAnyMace(ItemStack item) {
        return item != null && item.getType() == Material.MACE;
    }

    private void locateMace(CommandSender sender) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (ItemStack itemStack : player.getInventory().getContents()) {
                if (!this.isAnyMace(itemStack) && !this.isMaceInsideShulker(itemStack)) continue;
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "The Mace is in " + String.valueOf(ChatColor.AQUA) + player.getName() + "'s Inventory.");
                return;
            }
            for (ItemStack itemStack : player.getEnderChest().getContents()) {
                if (!this.isAnyMace(itemStack) && !this.isMaceInsideShulker(itemStack)) continue;
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "The Mace is in " + String.valueOf(ChatColor.AQUA) + player.getName() + "'s Ender Chest.");
                return;
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof AbstractHorse)) continue;
                AbstractHorse horse = (AbstractHorse)entity;
                for (ItemStack item : horse.getInventory().getContents()) {
                    if (!this.isAnyMace(item) && !this.isMaceInsideShulker(item)) continue;
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "The Mace is in a storage animal at " + String.valueOf(ChatColor.GOLD) + "X: " + entity.getLocation().getBlockX() + " Y: " + entity.getLocation().getBlockY() + " Z: " + entity.getLocation().getBlockZ() + String.valueOf(ChatColor.GRAY) + " in world " + entity.getWorld().getName());
                    return;
                }
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                Item item;
                ItemStack itemStack;
                if (!(entity instanceof Item) || !this.isAnyMace(itemStack = (item = (Item)entity).getItemStack()) && !this.isMaceInsideShulker(itemStack)) continue;
                Location loc = entity.getLocation();
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "The Mace is dropped at " + String.valueOf(ChatColor.GOLD) + "X: " + loc.getBlockX() + " Y: " + loc.getBlockY() + " Z: " + loc.getBlockZ() + String.valueOf(ChatColor.GRAY) + " in world " + loc.getWorld().getName());
                return;
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                for (BlockState state : chunk.getTileEntities()) {
                    if (!(state instanceof Container)) continue;
                    Container container = (Container)state;
                    Inventory inv2 = container.getInventory();
                    for (ItemStack item : inv2.getContents()) {
                        if (!this.isAnyMace(item) && !this.isMaceInsideShulker(item)) continue;
                        Location loc = state.getLocation();
                        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "The Mace is stored in a container at " + String.valueOf(ChatColor.GOLD) + "X: " + loc.getBlockX() + " Y: " + loc.getBlockY() + " Z: " + loc.getBlockZ() + String.valueOf(ChatColor.GRAY) + " in world " + loc.getWorld().getName());
                        return;
                    }
                }
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof StorageMinecart)) continue;
                StorageMinecart minecart = (StorageMinecart)entity;
                Inventory inventory = minecart.getInventory();
                for (ItemStack item : inventory.getContents()) {
                    if (!this.isAnyMace(item) && !this.isMaceInsideShulker(item)) continue;
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "The Mace is in a storage minecart at " + String.valueOf(ChatColor.GOLD) + "X: " + entity.getLocation().getBlockX() + " Y: " + entity.getLocation().getBlockY() + " Z: " + entity.getLocation().getBlockZ() + String.valueOf(ChatColor.GRAY) + " in world " + entity.getWorld().getName());
                    return;
                }
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof ChestBoat)) continue;
                ChestBoat chestBoat = (ChestBoat)entity;
                Inventory inventory = chestBoat.getInventory();
                for (ItemStack item : inventory.getContents()) {
                    if (!this.isAnyMace(item) && !this.isMaceInsideShulker(item)) continue;
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "The Mace is in a Chest Boat at " + String.valueOf(ChatColor.GOLD) + "X: " + entity.getLocation().getBlockX() + " Y: " + entity.getLocation().getBlockY() + " Z: " + entity.getLocation().getBlockZ() + String.valueOf(ChatColor.GRAY) + " in world " + entity.getWorld().getName());
                    return;
                }
            }
        }
        if (this.plugin.getConfig().isConfigurationSection("offline_inventory")) {
            for (String uuid : this.plugin.getConfig().getConfigurationSection("offline_inventory").getKeys(true)) {
                if (!this.plugin.getConfig().getBoolean("offline_inventory." + uuid, true)) continue;
                UUID offlineUUID = UUID.fromString(uuid);
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)offlineUUID);
                String name = offlinePlayer.getName();
                if (name != null) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "The Mace is in " + String.valueOf(ChatColor.AQUA) + name + String.valueOf(ChatColor.YELLOW) + "'s inventory (offline).");
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "The Mace is in an offline player's inventory (UUID: " + uuid + ").");
                }
                return;
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "The Mace is either missing or in an unloaded chunk.");
    }

    private boolean isMaceInsideShulker(ItemStack item) {
        BlockStateMeta blockStateMeta;
        BlockState blockState;
        if (item == null || item.getType() != Material.SHULKER_BOX) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof BlockStateMeta && (blockState = (blockStateMeta = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox) {
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            Inventory shulkerInv = shulkerBox.getInventory();
            for (ItemStack storedItem : shulkerInv.getContents()) {
                if (!this.plugin.isMace(storedItem)) continue;
                return true;
            }
        }
        return false;
    }

    private List<ItemStack> getMacesFromShulker(ItemStack item) {
        BlockState blockState;
        ArrayList<ItemStack> maces = new ArrayList<ItemStack>();
        if (item == null || item.getType() != Material.SHULKER_BOX) {
            return maces;
        }
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        if (meta == null || !((blockState = meta.getBlockState()) instanceof ShulkerBox)) {
            return maces;
        }
        ShulkerBox shulkerBox = (ShulkerBox)blockState;
        Inventory shulkerInv = shulkerBox.getInventory();
        for (ItemStack storedItem : shulkerInv.getContents()) {
            if (!this.isAnyMace(storedItem)) continue;
            maces.add(storedItem);
        }
        return maces;
    }
}

