import json


def create_frame_json(folder_anim, frame_move, frame_number):
    # Create the base structure for the JSON
    frame_data = {"credit": "Made By Toxicisity","parent": "item/generated",
        "textures": {"layer0": f"item/custom/{folder_anim}/{frame_move}{frame_number}"}
    }
    return frame_data

def save_frames(folder_anim,frame_move,num_frames):
    for i in range(1, num_frames + 1):
        frame_data = create_frame_json(folder_anim, frame_move, i)
        file_name = f"{frame_move}{i}.json"
        
        with open(file_name, 'w') as json_file:
            json.dump(frame_data, json_file, indent=4)
        print(f"Saved {file_name}")

if __name__ == "__main__":
    num_frames = 15  # Change this to the desired number of frames
    folder_anim = "spark"
    frame_moves = ["spark"]
    for i in frame_moves:
        save_frames(folder_anim, i, num_frames)