/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.client.renderer.entity;

import fuzs.shroomcraft.client.init.ModModelLayers;
import fuzs.shroomcraft.client.renderer.entity.layer.CluckshroomBlockStateLayer;
import fuzs.shroomcraft.client.renderer.entity.state.CluckshroomRenderState;
import fuzs.shroomcraft.world.entity.animal.Cluckshroom;
import fuzs.shroomcraft.world.entity.animal.MobBlockVariant;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class CluckshroomRenderer
extends AgeableMobRenderer<Cluckshroom, CluckshroomRenderState, ChickenModel> {
    public CluckshroomRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ChickenModel(context.bakeLayer(ModModelLayers.CLUCKSHROOM)), (EntityModel)new ChickenModel(context.bakeLayer(ModModelLayers.CLUCKSHROOM_BABY)), 0.3f);
        this.addLayer(new CluckshroomBlockStateLayer((RenderLayerParent<CluckshroomRenderState, ChickenModel>)this, context.getBlockRenderDispatcher()));
    }

    public static LayerDefinition createBodyLayer() {
        return ChickenModel.createBodyLayer().apply(meshDefinition -> {
            PartDefinition partDefinition = meshDefinition.getRoot();
            partDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(24, 13).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)3.0f, (float)13.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(24, 13).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)-3.0f, (float)13.0f, (float)0.0f));
            return meshDefinition;
        });
    }

    public ResourceLocation getTextureLocation(CluckshroomRenderState chickenRenderState) {
        return chickenRenderState.textureLocation;
    }

    public CluckshroomRenderState createRenderState() {
        return new CluckshroomRenderState();
    }

    public void extractRenderState(Cluckshroom cluckshroom, CluckshroomRenderState cluckshroomRenderState, float partialTick) {
        super.extractRenderState((LivingEntity)cluckshroom, (LivingEntityRenderState)cluckshroomRenderState, partialTick);
        cluckshroomRenderState.flap = Mth.lerp((float)partialTick, (float)cluckshroom.oFlap, (float)cluckshroom.flap);
        cluckshroomRenderState.flapSpeed = Mth.lerp((float)partialTick, (float)cluckshroom.oFlapSpeed, (float)cluckshroom.flapSpeed);
        cluckshroomRenderState.textureLocation = MobBlockVariant.transformTextureLocation(((MobBlockVariant)cluckshroom.getBlockVariant().value()).textureLocation());
        cluckshroomRenderState.blockState = ((MobBlockVariant)cluckshroom.getBlockVariant().value()).blockState();
    }
}

