/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.world.entity.animal;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.network.v4.codec.ExtraStreamCodecs;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import fuzs.shroomcraft.Shroomcraft;
import fuzs.shroomcraft.init.ModBlocks;
import fuzs.shroomcraft.init.ModLootTables;
import fuzs.shroomcraft.init.ModRegistry;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModMushroomCow
extends MushroomCow {
    private static final EntityDataAccessor<ColorVariant> DATA_VARIANT_ID = SynchedEntityData.defineId(ModMushroomCow.class, (EntityDataSerializer)((EntityDataSerializer)ModRegistry.MUSHROOM_VARIANT_ENTITY_DATA_SERIALIZER.value()));
    private static final Set<EntitySpawnReason> VALID_SPAWN_REASONS = Set.of(EntitySpawnReason.SPAWNER, EntitySpawnReason.TRIAL_SPAWNER, EntitySpawnReason.SPAWN_ITEM_USE, EntitySpawnReason.DISPENSER);
    @Nullable
    private UUID lastLightningBoltUUID;

    public ModMushroomCow(EntityType<? extends MushroomCow> entityType, Level level) {
        super(entityType, level);
    }

    public static boolean checkMooshroomSpawnRules(EntityType<? extends MushroomCow> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return ModMushroomCow.checkMushroomSpawnRules(entityType, (LevelAccessor)level, (EntitySpawnReason)spawnReason, (BlockPos)pos, (RandomSource)random) || level.getBlockState(pos.below()).is(BlockTags.NYLIUM);
    }

    public static EventResult onEntityLoad(Entity entity, ServerLevel serverLevel, boolean isNewlySpawned) {
        @Nullable EntitySpawnReason entitySpawnReason = EntityHelper.getMobSpawnReason((Entity)entity);
        if (isNewlySpawned && entitySpawnReason != null && entity.getType() == EntityType.MOOSHROOM && VALID_SPAWN_REASONS.contains(entitySpawnReason) && ModMushroomCow.getSpawnAsCustomEntityOdds(serverLevel, entity.blockPosition(), serverLevel.getRandom())) {
            MushroomCow mushroomCow = (MushroomCow)entity;
            mushroomCow.convertTo((EntityType)ModRegistry.MOOSHROOM_ENTITY_TYPE.value(), ConversionParams.single((Mob)mushroomCow, (boolean)true, (boolean)true), mob -> {
                @Nullable DifficultyInstance difficulty = new DifficultyInstance(serverLevel.getDifficulty(), serverLevel.getDayTime(), 0L, serverLevel.getMoonBrightness());
                mob.finalizeSpawn((ServerLevelAccessor)serverLevel, difficulty, entitySpawnReason, null);
            });
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static boolean getSpawnAsCustomEntityOdds(ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (serverLevel.getBiome(blockPos).is(BiomeTags.IS_NETHER)) {
            return true;
        }
        return randomSource.nextInt(ColorVariant.getOverworldVariants().length + 1) != 0;
    }

    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand interactionHand, Entity entity) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (itemInHand.is(Items.MOOSHROOM_SPAWN_EGG) && entity.isAlive() && entity.getType() == ModRegistry.MOOSHROOM_ENTITY_TYPE.value()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Optional<Mob> optional = ModMushroomCow.spawnOffspringFromSpawnEgg(player, (Mob)entity, serverLevel, entity.position(), itemInHand);
                optional.ifPresent(mob -> ((ModMushroomCow)entity).onOffspringSpawnedFromEgg(player, (Mob)mob));
                if (optional.isEmpty()) {
                    return EventResultHolder.interrupt((Object)InteractionResult.PASS);
                }
                return EventResultHolder.interrupt((Object)InteractionResult.CONSUME);
            }
            return EventResultHolder.interrupt((Object)InteractionResult.SUCCESS);
        }
        return EventResultHolder.pass();
    }

    private static Optional<Mob> spawnOffspringFromSpawnEgg(Player player, Mob mob, ServerLevel serverLevel, Vec3 pos, ItemStack stack) {
        AgeableMob mob2 = mob instanceof AgeableMob ? ((AgeableMob)mob).getBreedOffspring(serverLevel, (AgeableMob)mob) : null;
        if (mob2 == null) {
            return Optional.empty();
        }
        mob2.setBaby(true);
        if (!mob2.isBaby()) {
            return Optional.empty();
        }
        mob2.snapTo(pos.x(), pos.y(), pos.z(), 0.0f, 0.0f);
        serverLevel.addFreshEntityWithPassengers((Entity)mob2);
        mob2.setCustomName((Component)stack.get(DataComponents.CUSTOM_NAME));
        stack.consume(1, (LivingEntity)player);
        return Optional.of(mob2);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.removeAllGoals(BreedGoal.class::isInstance);
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0, MushroomCow.class));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)ColorVariant.BLUE);
    }

    public void thunderHit(ServerLevel serverLevel, LightningBolt lightningBolt) {
        UUID uuid = lightningBolt.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            ColorVariant[] colorVariants = this.getColorVariant().isNetherVariant() ? ColorVariant.getNetherVariants() : ColorVariant.getOverworldVariants();
            this.setColorVariant(colorVariants[(this.getColorVariant().typeIndex + 1) % colorVariants.length]);
            this.lastLightningBoltUUID = uuid;
            this.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        ColorVariant variant;
        if (spawnGroupData instanceof MooshroomGroupData) {
            MooshroomGroupData mooshroomGroupData = (MooshroomGroupData)((Object)spawnGroupData);
            variant = mooshroomGroupData.variant;
        } else {
            variant = ModMushroomCow.getRandomVariant((LevelAccessor)level, this.blockPosition());
            spawnGroupData = new MooshroomGroupData(variant);
        }
        this.setColorVariant(variant);
        return super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
    }

    private static ColorVariant getRandomVariant(LevelAccessor level, BlockPos pos) {
        Holder holder = level.getBiome(pos);
        if (holder.is(Biomes.CRIMSON_FOREST)) {
            return ColorVariant.CRIMSON;
        }
        if (holder.is(Biomes.WARPED_FOREST)) {
            return ColorVariant.WARPED;
        }
        ColorVariant[] colorVariants = holder.is(BiomeTags.IS_NETHER) ? ColorVariant.getNetherVariants() : ColorVariant.getOverworldVariants();
        return (ColorVariant)((Object)Util.getRandom((Object[])colorVariants, (RandomSource)level.getRandom()));
    }

    protected void dropFromShearingLootTable(ServerLevel level, ResourceKey<LootTable> lootTable, ItemStack shears, BiConsumer<ServerLevel, ItemStack> dropConsumer) {
        super.dropFromShearingLootTable(level, lootTable == BuiltInLootTables.SHEAR_MOOSHROOM ? ModLootTables.SHEAR_MOOSHROOM_LOOT_TABLE : lootTable, shears, dropConsumer);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.store(Shroomcraft.id("variant").toString(), ColorVariant.CODEC, (Object)this.getColorVariant());
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        valueInput.read(Shroomcraft.id("variant").toString(), ColorVariant.CODEC).ifPresent(this::setColorVariant);
    }

    public MushroomCow.Variant getVariant() {
        return MushroomCow.Variant.RED;
    }

    public void setColorVariant(ColorVariant colorVariant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)colorVariant);
    }

    public ColorVariant getColorVariant() {
        return (ColorVariant)((Object)this.entityData.get(DATA_VARIANT_ID));
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> dataComponentType) {
        return (T)(dataComponentType == ModRegistry.MOOSHROOM_VARIANT_DATA_COMPONENT_TYPE.value() ? ModMushroomCow.castComponentValue(dataComponentType, (Object)((Object)this.getColorVariant())) : super.get(dataComponentType));
    }

    protected void applyImplicitComponents(DataComponentGetter dataComponentGetter) {
        this.applyImplicitComponentIfPresent(dataComponentGetter, (DataComponentType)ModRegistry.MOOSHROOM_VARIANT_DATA_COMPONENT_TYPE.value());
        super.applyImplicitComponents(dataComponentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> dataComponentType, T object) {
        if (dataComponentType == ModRegistry.MOOSHROOM_VARIANT_DATA_COMPONENT_TYPE.value()) {
            this.setColorVariant((ColorVariant)((Object)ModMushroomCow.castComponentValue((DataComponentType)((DataComponentType)ModRegistry.MOOSHROOM_VARIANT_DATA_COMPONENT_TYPE.value()), object)));
            return true;
        }
        return super.applyImplicitComponent(dataComponentType, object);
    }

    @Nullable
    public MushroomCow getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        ModMushroomCow modMushroomCow = (ModMushroomCow)this.getType().create((Level)level, EntitySpawnReason.BREEDING);
        if (modMushroomCow != null) {
            modMushroomCow.setColorVariant(this.getColorVariant());
        }
        return modMushroomCow;
    }

    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)Items.MOOSHROOM_SPAWN_EGG);
    }

    public boolean canMate(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        return otherAnimal instanceof MushroomCow && this.isInLove() && otherAnimal.isInLove();
    }

    public static enum ColorVariant implements StringRepresentable
    {
        BLUE(0, (Holder<Block>)ModBlocks.BLUE_MUSHROOM),
        ORANGE(1, (Holder<Block>)ModBlocks.ORANGE_MUSHROOM),
        PURPLE(2, (Holder<Block>)ModBlocks.PURPLE_MUSHROOM),
        CRIMSON(0, (Holder<Block>)Blocks.CRIMSON_FUNGUS.builtInRegistryHolder()),
        WARPED(1, (Holder<Block>)Blocks.WARPED_FUNGUS.builtInRegistryHolder());

        public static final StringRepresentable.StringRepresentableCodec<ColorVariant> CODEC;
        public static final StreamCodec<ByteBuf, ColorVariant> STREAM_CODEC;
        private final int typeIndex;
        public final Holder<Block> block;

        private ColorVariant(int typeIndex, Holder<Block> block) {
            this.typeIndex = typeIndex;
            this.block = block;
        }

        public static ColorVariant[] getOverworldVariants() {
            return (ColorVariant[])Arrays.stream(ColorVariant.values()).filter(ColorVariant::isOverworldVariant).toArray(ColorVariant[]::new);
        }

        public static ColorVariant[] getNetherVariants() {
            return (ColorVariant[])Arrays.stream(ColorVariant.values()).filter(ColorVariant::isNetherVariant).toArray(ColorVariant[]::new);
        }

        public boolean isOverworldVariant() {
            return !this.isNetherVariant();
        }

        public boolean isNetherVariant() {
            return this == CRIMSON || this == WARPED;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(ColorVariant::values);
            STREAM_CODEC = ExtraStreamCodecs.fromEnum(ColorVariant.class);
        }
    }

    static class MooshroomGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final ColorVariant variant;

        MooshroomGroupData(ColorVariant variant) {
            super(true);
            this.variant = variant;
        }
    }
}

