/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TinyMushroomCropBlock
extends TorchflowerCropBlock {
    public static final MapCodec<TorchflowerCropBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TinyMushroomCropBlock.propertiesCodec(), (App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("plant").forGetter(block -> ((TinyMushroomCropBlock)block).plantBlock)).apply((Applicative)instance, TinyMushroomCropBlock::new));
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    private final Holder<Block> plantBlock;

    public TinyMushroomCropBlock(BlockBehaviour.Properties properties, Holder<Block> plantBlock) {
        super(properties);
        this.plantBlock = plantBlock;
    }

    public MapCodec<TorchflowerCropBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.MUSHROOM_GROW_BLOCK);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 3 && random.nextInt(10) == 0) {
            state = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1));
            level.setBlock(pos, state, 2);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemLike getBaseSeedId() {
        return this;
    }

    public BlockState getStateForAge(int age) {
        return age == 2 ? ((Block)this.plantBlock.value()).defaultBlockState() : super.getStateForAge(age);
    }
}

