/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.world.item.crafting;

import com.mojang.serialization.MapCodec;
import fuzs.shroomcraft.init.ModRegistry;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class DistinctShapelessRecipe
extends ShapelessRecipe {
    public DistinctShapelessRecipe(ShapelessRecipe shapelessRecipe) {
        super(shapelessRecipe.group(), shapelessRecipe.category(), shapelessRecipe.assemble(CraftingInput.EMPTY, (HolderLookup.Provider)RegistryAccess.EMPTY), shapelessRecipe.ingredients);
    }

    public DistinctShapelessRecipe(String group, CraftingBookCategory category, ItemStack result, List<Ingredient> ingredients) {
        super(group, category, result, ingredients);
    }

    public RecipeSerializer<ShapelessRecipe> getSerializer() {
        return (RecipeSerializer)ModRegistry.DISTINCT_SHAPELESS_RECIPE_SERIALIZER.value();
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.items().stream().filter(Predicate.not(ItemStack::isEmpty)).map(ItemStack::getItem).distinct().count() != input.items().stream().filter(Predicate.not(ItemStack::isEmpty)).count()) {
            return false;
        }
        return super.matches(input, level);
    }

    public static class Serializer
    implements RecipeSerializer<DistinctShapelessRecipe> {
        private static final MapCodec<DistinctShapelessRecipe> CODEC = RecipeSerializer.SHAPELESS_RECIPE.codec().xmap(DistinctShapelessRecipe::new, Function.identity());
        public static final StreamCodec<RegistryFriendlyByteBuf, DistinctShapelessRecipe> STREAM_CODEC = RecipeSerializer.SHAPELESS_RECIPE.streamCodec().map(DistinctShapelessRecipe::new, Function.identity());

        public MapCodec<DistinctShapelessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DistinctShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

