/*
 * Decompiled with CFR 0.152.
 */
package fuzs.shroomcraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.shroomcraft.init.ModRegistry;
import fuzs.shroomcraft.world.entity.animal.MobBlockVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_10179;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1394;
import net.minecraft.class_1428;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5147;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7988;
import org.jetbrains.annotations.Nullable;

public class Cluckshroom
extends class_1428
implements class_5147,
class_7988<class_6880<MobBlockVariant>> {
    private static final class_2940<class_6880<MobBlockVariant>> DATA_TYPE = class_2945.method_12791(Cluckshroom.class, (class_2941)((class_2941)ModRegistry.CLUCKSHROOM_VARIANT_ENTITY_DATA_SERIALIZER.comp_349()));
    @Nullable
    private UUID lastLightningBoltUUID;

    public Cluckshroom(class_1299<? extends class_1428> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static boolean checkMushroomSpawnRules(class_1299<? extends class_1308> entityType, class_1936 level, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return level.method_8320(pos.method_10074()).method_26164(class_3481.field_35570) && Cluckshroom.method_39448((class_1920)level, (class_2338)pos);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_35113(class_1394.class::isInstance);
        this.field_6201.method_6277(5, (class_1352)new CluckshroomRandomStrollGoal(this, 1.0));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        class_2378 registry = this.method_56673().method_30530(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY);
        builder.method_56912(DATA_TYPE, (Object)((class_6880)registry.method_46746(ModRegistry.RED_CLUCKSHROOM_VARIANT).or(() -> ((class_2378)registry).method_60385()).orElseThrow()));
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (itemInHand.method_31574(class_1802.field_8428) && !this.method_6109()) {
            class_1799 newItemInHand = class_5328.method_30270((class_1799)itemInHand, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8208), (boolean)false);
            player.method_6122(hand, newItemInHand);
            this.method_5783(class_3417.field_18268, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (itemInHand.method_31574(class_1802.field_8868) && this.method_27072()) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                this.method_6636(serverLevel, class_3419.field_15248, itemInHand);
                this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                itemInHand.method_7970(1, (class_1309)player, Cluckshroom.method_56079((class_1268)hand));
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void method_6007() {
        this.field_6739 = 6000;
        super.method_6007();
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnGroupData) {
        class_6880<MobBlockVariant> variant;
        if (spawnGroupData instanceof MobBlockVariantGroupData) {
            MobBlockVariantGroupData mobBlockVariantGroupData = (MobBlockVariantGroupData)((Object)spawnGroupData);
            variant = mobBlockVariantGroupData.variant;
        } else {
            class_6880 biome = level.method_23753(this.method_24515());
            variant = Cluckshroom.getSpawnVariant(this.method_56673(), (class_6880<class_1959>)biome);
            spawnGroupData = new MobBlockVariantGroupData(variant);
        }
        this.setVariant(variant);
        return super.method_5943(level, difficulty, spawnReason, spawnGroupData);
    }

    public static class_6880<MobBlockVariant> getSpawnVariant(class_5455 registryAccess, class_6880<class_1959> biome) {
        class_2378 registry = registryAccess.method_30530(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY);
        return Cluckshroom.getRandomSpawnVariant((class_2378<MobBlockVariant>)registry, holder -> ((MobBlockVariant)holder.comp_349()).biomes().method_40241(biome)).or(() -> Cluckshroom.getRandomSpawnVariant((class_2378<MobBlockVariant>)registry, holder -> {
            class_6862<MobBlockVariant> tagKey = biome.method_40220(class_6908.field_36518) ? ModRegistry.NETHER_SPAWNS_CLUCKSHROOM_VARIANT_TAG : ModRegistry.DEFAULT_SPAWNS_CLUCKSHROOM_VARIANT_TAG;
            return holder.method_40220(tagKey);
        })).or(() -> registry.method_46746(ModRegistry.RED_CLUCKSHROOM_VARIANT)).or(() -> ((class_2378)registry).method_60385()).orElseThrow();
    }

    static Optional<class_6880<MobBlockVariant>> getRandomSpawnVariant(class_2378<MobBlockVariant> registry, Predicate<class_6880<MobBlockVariant>> filter) {
        return Optional.ofNullable((class_6880)registry.method_42017().filter(filter).collect(Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), list -> {
            Collections.shuffle(list);
            return !list.isEmpty() ? (class_6880.class_6883)list.getFirst() : null;
        })));
    }

    public void method_5800(class_3218 serverLevel, class_1538 lightningBolt) {
        UUID uuid = lightningBolt.method_5667();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            class_2378 registry = this.method_56673().method_30530(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY);
            int newIndex = (registry.method_56158((Object)((MobBlockVariant)this.getVariant().comp_349())) + 1) % registry.method_10204();
            this.setVariant((class_6880<MobBlockVariant>)((class_6880)registry.method_40265(newIndex).orElseThrow(NoSuchElementException::new)));
            this.lastLightningBoltUUID = uuid;
            this.method_5783(class_3417.field_18266, 2.0f, 1.0f);
        }
    }

    public void method_6636(class_3218 level, class_3419 soundSource, class_1799 shears) {
        level.method_43129(null, (class_1297)this, class_3417.field_14705, soundSource, 1.0f, 1.0f);
        this.method_29243(class_1299.field_6132, class_10179.method_63607((class_1308)this, (boolean)false, (boolean)false), cow -> {
            level.method_14199((class_2394)class_2398.field_11236, this.method_23317(), this.method_23323(0.5), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
            this.method_61419(level, ((MobBlockVariant)this.getVariant().comp_349()).shearingLootTable(), shears, (serverLevelx, itemStackx) -> {
                for (int i = 0; i < itemStackx.method_7947(); ++i) {
                    serverLevelx.method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23323(1.0), this.method_23321(), itemStackx.method_46651(1)));
                }
            });
        });
    }

    public boolean method_27072() {
        return this.method_5805() && !this.method_6109();
    }

    public void setVariant(class_6880<MobBlockVariant> variant) {
        this.field_6011.method_12778(DATA_TYPE, variant);
    }

    public class_6880<MobBlockVariant> getVariant() {
        return (class_6880)this.field_6011.method_12789(DATA_TYPE);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        MobBlockVariant.codec(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY).encodeStart((DynamicOps)class_2509.field_11560, this.getVariant()).ifSuccess(tagX -> tag.method_10566("variant", tagX));
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        MobBlockVariant.codec(ModRegistry.CLUCKSHROOM_VARIANT_REGISTRY_KEY).parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("variant")).ifSuccess(this::setVariant);
    }

    @Nullable
    public Cluckshroom getBreedOffspring(class_3218 level, class_1296 otherParent) {
        Cluckshroom cluckshroom = (Cluckshroom)this.method_5864().method_5883((class_1937)level, class_3730.field_16466);
        if (cluckshroom != null) {
            cluckshroom.setVariant(this.getVariant());
        }
        return cluckshroom;
    }

    public static class CluckshroomRandomStrollGoal
    extends class_1394 {
        public <T extends class_1314> CluckshroomRandomStrollGoal(T mob, double speedModifier) {
            super(mob, speedModifier);
        }

        public void method_6268() {
            class_3218 serverLevel = CluckshroomRandomStrollGoal.method_64451((class_1297)this.field_6566);
            if (CommonAbstractions.INSTANCE.getMobGriefingRule(serverLevel, (class_1297)this.field_6566) && !this.field_6566.method_6109() && serverLevel.field_9229.method_43048(1000) == 0 && this.field_6566.method_18798().method_1027() > (double)1.0E-5f) {
                class_2338 blockPos = this.field_6566.method_24515();
                class_2680 blockState = ((MobBlockVariant)((class_6880)((class_7988)this.field_6566).method_47827()).comp_349()).blockState();
                if (serverLevel.method_8320(blockPos).method_26215() && blockState.method_26184((class_4538)serverLevel, blockPos)) {
                    serverLevel.method_8501(blockPos, blockState);
                    class_2498 soundType = blockState.method_26231();
                    serverLevel.method_8396(null, blockPos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
                    serverLevel.method_43276((class_6880)class_5712.field_28164, blockPos, class_5712.class_7397.method_43286((class_1297)this.field_6566, (class_2680)blockState));
                }
            }
        }
    }

    public static class MobBlockVariantGroupData
    extends class_1296.class_4697 {
        public final class_6880<MobBlockVariant> variant;

        public MobBlockVariantGroupData(class_6880<MobBlockVariant> variant) {
            this(variant, true);
        }

        public MobBlockVariantGroupData(class_6880<MobBlockVariant> variant, boolean shouldSpawnBaby) {
            super(shouldSpawnBaby);
            this.variant = variant;
        }
    }
}

