/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.reColorfulMap;

import cn.lunadeer.reColorfulMap.Configuration;
import cn.lunadeer.reColorfulMap.ImageRenderer;
import cn.lunadeer.reColorfulMap.Language;
import cn.lunadeer.reColorfulMap.PDCImageManager;
import cn.lunadeer.reColorfulMap.ReColorfulMap;
import cn.lunadeer.reColorfulMap.utils.ImageUtils;
import cn.lunadeer.reColorfulMap.utils.Notification;
import cn.lunadeer.reColorfulMap.utils.XLogger;
import cn.lunadeer.reColorfulMap.utils.configuration.ConfigurationPart;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;
import org.bukkit.persistence.PersistentDataType;

public class ImageMapItem
extends ItemStack {
    private final Integer x_count;
    private final Integer y_count;
    private final byte[][][] tile_b64_matrix;
    private final byte[] thumb_b64;
    private final World world;
    private Integer mapview_id;

    public ImageMapItem(World world, String url, Float scale) throws Exception {
        super(Material.FILLED_MAP);
        this.world = world;
        if (!ImageMapItem.checkUrlAvailable(url)) {
            throw new Exception(Language.imageMapItem.urlNotAllowed.formatted(url));
        }
        URL _url = new URL(url);
        BufferedImage raw_image = ImageIO.read(_url);
        if (raw_image == null) {
            throw new Exception(Language.imageMapItem.readImageFailed);
        }
        BufferedImage resized_image = (double)scale.floatValue() != 1.0 ? ImageUtils.resize(raw_image, scale.floatValue()) : raw_image;
        int image_width = resized_image.getWidth();
        int image_height = resized_image.getHeight();
        this.x_count = (int)Math.ceil((double)image_width / 128.0);
        this.y_count = (int)Math.ceil((double)image_height / 128.0);
        if (this.x_count > Configuration.maxFrameX || this.y_count > Configuration.maxFrameY) {
            throw new Exception(Language.imageMapItem.imageSizeNotAllowed.formatted(Configuration.maxFrameX * 128, Configuration.maxFrameY * 128));
        }
        int new_width = this.x_count * 128;
        int new_height = this.y_count * 128;
        BufferedImage centered_image = ImageUtils.center(resized_image, new_width, new_height);
        image_width = centered_image.getWidth();
        image_height = centered_image.getHeight();
        this.tile_b64_matrix = new byte[this.y_count.intValue()][this.x_count.intValue()][];
        for (int y = 0; y < this.y_count; ++y) {
            for (int x = 0; x < this.x_count; ++x) {
                int width = Math.min(128, image_width - x * 128);
                int height = Math.min(128, image_height - y * 128);
                BufferedImage sub_image = centered_image.getSubimage(x * 128, y * 128, width, height);
                this.tile_b64_matrix[y][x] = ImageUtils.encodeImageToBase64(sub_image, "png");
            }
        }
        if (this.tile_b64_matrix.length == 0) {
            throw new Exception(Language.imageMapItem.matrixGenerateFailed);
        }
        this.thumb_b64 = ImageUtils.encodeImageToBase64(ImageUtils.thumb(raw_image), "png");
        MapMeta meta = (MapMeta)this.getItemMeta();
        meta.getPersistentDataContainer().set(ImageMapItem.THUMB_KEY(), PersistentDataType.BYTE_ARRAY, (Object)this.thumb_b64);
        meta.getPersistentDataContainer().set(ImageMapItem.MATRIX_X_KEY(), PersistentDataType.INTEGER, (Object)this.tile_b64_matrix[0].length);
        meta.getPersistentDataContainer().set(ImageMapItem.MATRIX_Y_KEY(), PersistentDataType.INTEGER, (Object)this.tile_b64_matrix.length);
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        lore.add(Component.text("X: %d".formatted(this.x_count)));
        lore.add(Component.text("Y: %d".formatted(this.y_count)));
        meta.lore(lore);
        this.setItemMeta((ItemMeta)meta);
        this.setUpThumbnail();
        for (int y = 0; y < this.y_count; ++y) {
            for (int x = 0; x < this.x_count; ++x) {
                this.saveTileToWorldPDC(x, y);
            }
        }
        XLogger.debug("ImageMapItem created: %s".formatted(url));
        XLogger.debug("ImageMapItem size: %dx%d".formatted(this.x_count, this.y_count));
    }

    public void setUpThumbnail() throws Exception {
        if (this.mapview_id != null) {
            PDCImageManager.removeThumbnailFromWorldPDC(this);
        }
        MapMeta meta = (MapMeta)this.getItemMeta();
        MapView mapView = Bukkit.createMap((World)this.world);
        meta.setMapView(mapView);
        this.mapview_id = mapView.getId();
        BufferedImage thumb_image = ImageUtils.decodeBase64ToImage(this.thumb_b64);
        if (thumb_image == null) {
            return;
        }
        ImageRenderer.renderOnMeta(meta, thumb_image);
        PDCImageManager.addThumbnailToWorldPDC(this);
        this.setItemMeta((ItemMeta)meta);
    }

    public ImageMapItem(ItemStack mapItem) throws Exception {
        super(mapItem);
        MapMeta meta = (MapMeta)mapItem.getItemMeta();
        if (!meta.getPersistentDataContainer().has(ImageMapItem.THUMB_KEY(), PersistentDataType.BYTE_ARRAY)) {
            throw new Exception("IGNORING: Not an ImageMapItem");
        }
        this.thumb_b64 = (byte[])meta.getPersistentDataContainer().get(ImageMapItem.THUMB_KEY(), PersistentDataType.BYTE_ARRAY);
        this.x_count = (Integer)meta.getPersistentDataContainer().get(ImageMapItem.MATRIX_X_KEY(), PersistentDataType.INTEGER);
        this.y_count = (Integer)meta.getPersistentDataContainer().get(ImageMapItem.MATRIX_Y_KEY(), PersistentDataType.INTEGER);
        if (this.x_count == null || this.y_count == null) {
            throw new Exception(Language.imageMapItem.imageCorrupt);
        }
        if (meta.getMapView() == null) {
            throw new Exception(Language.imageMapItem.imageCorrupt);
        }
        this.world = meta.getMapView().getWorld();
        this.mapview_id = meta.getMapView().getId();
        this.tile_b64_matrix = new byte[this.y_count.intValue()][this.x_count.intValue()][];
        for (int y = 0; y < this.y_count; ++y) {
            for (int x = 0; x < this.x_count; ++x) {
                this.tile_b64_matrix[y][x] = this.getTileFromWorldPDC(x, y);
            }
        }
        this.setItemMeta((ItemMeta)meta);
    }

    public void setMapviewId(int id) {
        this.mapview_id = id;
    }

    public World getWorld() {
        return this.world;
    }

    public Integer getXCount() {
        return this.x_count;
    }

    public Integer getYCount() {
        return this.y_count;
    }

    public byte[] getThumbBase64() {
        return this.thumb_b64;
    }

    public Integer getMapviewId() {
        return this.mapview_id;
    }

    public byte[] getTileBase64(int x, int y) {
        return this.tile_b64_matrix[y][x];
    }

    public void setTileBase64(int x, int y, byte[] base64) {
        this.tile_b64_matrix[y][x] = base64;
    }

    private static NamespacedKey THUMB_KEY() {
        return new NamespacedKey("re_colorful_map", "thumb");
    }

    private static NamespacedKey MATRIX_X_KEY() {
        return new NamespacedKey("re_colorful_map", "matrix_x");
    }

    private static NamespacedKey MATRIX_Y_KEY() {
        return new NamespacedKey("re_colorful_map", "matrix_y");
    }

    private static NamespacedKey IMAGE_TILE_KEY(int mapId, int x, int y) {
        return new NamespacedKey("re_colorful_map", "%d_tile_%d_%d".formatted(mapId, x, y));
    }

    public void saveTileToWorldPDC(int x, int y) {
        Objects.requireNonNull(this.world).getPersistentDataContainer().set(ImageMapItem.IMAGE_TILE_KEY(this.mapview_id, x, y), PersistentDataType.BYTE_ARRAY, (Object)this.tile_b64_matrix[y][x]);
    }

    public void removeTileFromWorldPDC(int x, int y) {
        Objects.requireNonNull(this.world).getPersistentDataContainer().remove(ImageMapItem.IMAGE_TILE_KEY(this.mapview_id, x, y));
    }

    public byte[] getTileFromWorldPDC(int x, int y) {
        return (byte[])Objects.requireNonNull(this.world).getPersistentDataContainer().get(ImageMapItem.IMAGE_TILE_KEY(this.mapview_id, x, y), PersistentDataType.BYTE_ARRAY);
    }

    private static boolean checkUrlAvailable(String url) {
        if (Configuration.addressWhiteList.isEmpty()) {
            return true;
        }
        for (String whiteUrl : Configuration.addressWhiteList) {
            if (url.startsWith(whiteUrl)) {
                return true;
            }
            if (url.startsWith("http://" + whiteUrl)) {
                return true;
            }
            if (!url.startsWith("https://" + whiteUrl)) continue;
            return true;
        }
        return false;
    }

    public static void pureImageTiles(CommandSender sender) {
        AtomicInteger count = new AtomicInteger();
        ReColorfulMap.getInstance().getServer().getWorlds().forEach(world -> world.getPersistentDataContainer().getKeys().forEach(key -> {
            if (key.getNamespace().equals("re_colorful_map")) {
                String regex = "\\d+_tile_\\d+_\\d+";
                if (key.getKey().matches(regex)) {
                    world.getPersistentDataContainer().remove(key);
                    count.getAndIncrement();
                }
            }
        }));
        Notification.info(sender, Language.imageMapItem.removedImageTiles.formatted(count.get()));
    }

    public static class ImageMapItemText
    extends ConfigurationPart {
        public String imageCorrupt = "Image corrupted, cannot load. Please regenerate.";
        public String urlNotAllowed = "This image URL (%s) is not allowed";
        public String readImageFailed = "Failed to read image, please check if the image URL is correct or change the image host";
        public String imageSizeNotAllowed = "Image too large, resolution must not exceed %dx%d";
        public String matrixGenerateFailed = "Failed to generate image matrix";
        public String removedImageTiles = "Removed %d unused image tiles.";
    }
}

