/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.reColorfulMap;

import cn.lunadeer.reColorfulMap.Language;
import cn.lunadeer.reColorfulMap.utils.ImageUtils;
import cn.lunadeer.reColorfulMap.utils.Notification;
import cn.lunadeer.reColorfulMap.utils.configuration.ConfigurationPart;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.jetbrains.annotations.NotNull;

public class ImageRenderer
extends MapRenderer {
    private final BufferedImage image;

    public ImageRenderer(BufferedImage image) {
        this.image = image;
    }

    public void render(@NotNull MapView map, @NotNull MapCanvas canvas, @NotNull Player player) {
        try {
            if (this.image.getWidth() > 128 || this.image.getHeight() > 128) {
                throw new Exception(Language.imageRenderer.imageTooLarge.formatted(this.image.getWidth(), this.image.getHeight()));
            }
            int x_offset = (128 - this.image.getWidth()) / 2;
            int y_offset = (128 - this.image.getHeight()) / 2;
            canvas.drawImage(x_offset, y_offset, (Image)this.image);
        }
        catch (Exception e) {
            Notification.error(player, Language.imageRenderer.failToRender.formatted(e.getMessage()));
        }
    }

    public static MapMeta renderOnMeta(MapMeta meta, byte[] base64) throws Exception {
        BufferedImage image = ImageUtils.decodeBase64ToImage(base64);
        return ImageRenderer.renderOnMeta(meta, image);
    }

    public static MapMeta renderOnMeta(MapMeta meta, BufferedImage image) throws Exception {
        MapView view = meta.getMapView();
        if (view == null) {
            throw new Exception("MapMeta does not have a MapView.");
        }
        view.getRenderers().clear();
        view.addRenderer((MapRenderer)new ImageRenderer(image));
        meta.setMapView(view);
        return meta;
    }

    public static class ImageRendererText
    extends ConfigurationPart {
        public String failToRender = "Failed to render image: %s";
        public String imageTooLarge = "image (%d x %d) is too large.";
    }
}

