/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.reColorfulMap;

import cn.lunadeer.reColorfulMap.ImageMapItem;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.persistence.PersistentDataType;

public class PDCImageManager {
    public static void addThumbnailToWorldPDC(ImageMapItem imageMap) {
        World world = imageMap.getWorld();
        int mapViewId = imageMap.getMapviewId();
        byte[] base64 = imageMap.getThumbBase64();
        PDCImageManager.addImageBase64WorldPDC(world, mapViewId, base64);
    }

    public static void removeThumbnailFromWorldPDC(ImageMapItem imageMap) {
        World world = imageMap.getWorld();
        int mapViewId = imageMap.getMapviewId();
        PDCImageManager.removeImageBase64WorldPDC(world, mapViewId);
    }

    public static void addImageBase64WorldPDC(World world, int mapViewId, byte[] base64) {
        world.getPersistentDataContainer().set(new NamespacedKey("re_colorful_map", "mapview_id_%d".formatted(mapViewId)), PersistentDataType.BYTE_ARRAY, (Object)base64);
    }

    public static byte[] getImageBase64WorldPDC(World world, int mapViewId) {
        return (byte[])world.getPersistentDataContainer().get(new NamespacedKey("re_colorful_map", "mapview_id_%d".formatted(mapViewId)), PersistentDataType.BYTE_ARRAY);
    }

    public static void removeImageBase64WorldPDC(World world, int mapViewId) {
        world.getPersistentDataContainer().remove(new NamespacedKey("re_colorful_map", "mapview_id_%d".formatted(mapViewId)));
    }
}

