/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.reColorfulMap.events;

import cn.lunadeer.reColorfulMap.Configuration;
import cn.lunadeer.reColorfulMap.ImageMapItem;
import cn.lunadeer.reColorfulMap.ImageRenderer;
import cn.lunadeer.reColorfulMap.Language;
import cn.lunadeer.reColorfulMap.PDCImageManager;
import cn.lunadeer.reColorfulMap.utils.ImageUtils;
import cn.lunadeer.reColorfulMap.utils.Notification;
import cn.lunadeer.reColorfulMap.utils.VaultConnect.VaultConnect;
import cn.lunadeer.reColorfulMap.utils.XLogger;
import cn.lunadeer.reColorfulMap.utils.configuration.ConfigurationPart;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;
import org.bukkit.persistence.PersistentDataType;

public class ImageMapEvent
implements Listener {
    private static final NamespacedKey originMapLocationX = new NamespacedKey("re_colorful_map", "origin_map_location_x");
    private static final NamespacedKey originMapLocationY = new NamespacedKey("re_colorful_map", "origin_map_location_y");
    private static final NamespacedKey originMapLocationZ = new NamespacedKey("re_colorful_map", "origin_map_location_z");
    private static final NamespacedKey tileBase64 = new NamespacedKey("re_colorful_map", "tile_base64");

    @EventHandler(priority=EventPriority.HIGHEST)
    public void putImageMapsOnItemFrame(PlayerInteractEntityEvent event) {
        ImageMapItem imageMapItem;
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame item_frame = (ItemFrame)entity;
        Player player = event.getPlayer();
        try {
            imageMapItem = new ImageMapItem(event.getPlayer().getInventory().getItemInMainHand());
            XLogger.debug("ImageMapItem size: %d x %d", imageMapItem.getXCount(), imageMapItem.getYCount());
        }
        catch (Exception e) {
            XLogger.debug("Not a image map: %s", e.getMessage());
            return;
        }
        event.setCancelled(true);
        try {
            ItemFrame[][] item_frames = ImageMapEvent.getItemFrameMatrix(item_frame, imageMapItem.getXCount(), imageMapItem.getYCount());
            if (Configuration.economy.enable) {
                double cost = Configuration.economy.costPerMap * (double)imageMapItem.getXCount().intValue() * (double)imageMapItem.getYCount().intValue();
                if (!VaultConnect.instance.economyAvailable()) {
                    Notification.error(player, Language.imageMapEvent.hookEconomyFailed);
                    return;
                }
                if (VaultConnect.instance.getBalance(player) < cost) {
                    Notification.error(player, Language.imageMapEvent.balanceNotEnough);
                    Notification.error(player, Language.imageMapEvent.priceInfo, imageMapItem.getXCount(), imageMapItem.getYCount(), Configuration.economy.costPerMap, cost, VaultConnect.instance.getBalance(player));
                    return;
                }
                VaultConnect.instance.withdrawPlayer(player, cost);
            }
            for (int j = 0; j < imageMapItem.getYCount(); ++j) {
                for (int i = 0; i < imageMapItem.getXCount(); ++i) {
                    XLogger.debug("Checking item frame [%d, %d] %s", i, j, item_frames[i][j].getLocation().toString());
                    player.getInventory().setItemInMainHand(new ItemStack(Material.FILLED_MAP));
                    PlayerInteractEntityEvent event_put_map = new PlayerInteractEntityEvent(player, (Entity)item_frames[i][j]);
                    Bukkit.getPluginManager().callEvent((Event)event_put_map);
                    if (!event_put_map.isCancelled()) continue;
                    player.getInventory().setItemInMainHand((ItemStack)imageMapItem);
                    XLogger.debug("Item frame [%d, %d] is not interactable (cancelled)", i, j);
                    return;
                }
            }
            player.getInventory().setItemInMainHand((ItemStack)imageMapItem);
            ItemStack[][] tileMatrix = ImageMapEvent.getTileMatrix(item_frame, imageMapItem);
            for (int j = 0; j < imageMapItem.getYCount(); ++j) {
                for (int i = 0; i < imageMapItem.getXCount(); ++i) {
                    item_frames[i][j].setItem(new ItemStack(Material.AIR));
                    item_frames[i][j].setItem(tileMatrix[i][j]);
                }
            }
        }
        catch (Exception e) {
            Notification.error(player, e.getMessage());
            return;
        }
        player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        PDCImageManager.removeThumbnailFromWorldPDC(imageMapItem);
    }

    private static ItemStack[][] getTileMatrix(ItemFrame originItemFrame, ImageMapItem imageMapItem) throws Exception {
        World world = originItemFrame.getWorld();
        ItemStack[][] tileMatrix = new ItemStack[imageMapItem.getXCount().intValue()][imageMapItem.getYCount().intValue()];
        for (int j = imageMapItem.getYCount() - 1; j >= 0; --j) {
            for (int i = 0; i < imageMapItem.getXCount(); ++i) {
                byte[] tile_b64 = imageMapItem.getTileBase64(i, j);
                ItemStack mapItem = new ItemStack(Material.FILLED_MAP);
                MapMeta meta = (MapMeta)mapItem.getItemMeta();
                if (i == 0 && j == imageMapItem.getYCount() - 1) {
                    meta = (MapMeta)imageMapItem.getItemMeta();
                }
                meta.getPersistentDataContainer().set(originMapLocationX, PersistentDataType.INTEGER, (Object)originItemFrame.getLocation().getBlockX());
                meta.getPersistentDataContainer().set(originMapLocationY, PersistentDataType.INTEGER, (Object)originItemFrame.getLocation().getBlockY());
                meta.getPersistentDataContainer().set(originMapLocationZ, PersistentDataType.INTEGER, (Object)originItemFrame.getLocation().getBlockZ());
                meta.getPersistentDataContainer().set(tileBase64, PersistentDataType.BYTE_ARRAY, (Object)tile_b64);
                BufferedImage image = ImageUtils.decodeBase64ToImage(tile_b64);
                MapView mapView = Bukkit.createMap((World)world);
                meta.setMapView(mapView);
                ImageRenderer.renderOnMeta(meta, image);
                mapItem.setItemMeta((ItemMeta)meta);
                tileMatrix[i][j] = mapItem;
                PDCImageManager.addImageBase64WorldPDC(world, mapView.getId(), tile_b64);
                imageMapItem.removeTileFromWorldPDC(i, j);
            }
        }
        return tileMatrix;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void itemFrameBroken(HangingBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemFrame originItemFrame = ImageMapEvent.TryGetOriginItemFrame((Entity)event.getEntity());
        if (originItemFrame == null) {
            return;
        }
        ImageMapItem imageMapItem = ImageMapEvent.TryGetImageMapItem(originItemFrame.getItem());
        if (imageMapItem == null) {
            return;
        }
        ImageMapEvent.HandleBroken(originItemFrame, imageMapItem);
        event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), (ItemStack)imageMapItem);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void breakImageMapsFromItemFrame(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemFrame originItemFrame = ImageMapEvent.TryGetOriginItemFrame(event.getEntity());
        if (originItemFrame == null) {
            return;
        }
        ImageMapItem imageMapItem = ImageMapEvent.TryGetImageMapItem(originItemFrame.getItem());
        if (imageMapItem == null) {
            return;
        }
        event.setCancelled(true);
        ImageMapEvent.HandleBroken(originItemFrame, imageMapItem);
        event.getDamager().getWorld().dropItemNaturally(event.getEntity().getLocation(), (ItemStack)imageMapItem);
    }

    @Nullable
    private static ItemFrame TryGetOriginItemFrame(Entity entity) {
        if (!(entity instanceof ItemFrame)) {
            return null;
        }
        ItemFrame clicked_item_frame = (ItemFrame)entity;
        if (clicked_item_frame.getItem().getType() != Material.FILLED_MAP) {
            return null;
        }
        ItemStack mapItemStack = clicked_item_frame.getItem();
        if (!(mapItemStack.getItemMeta().getPersistentDataContainer().has(originMapLocationX) && mapItemStack.getItemMeta().getPersistentDataContainer().has(originMapLocationY) && mapItemStack.getItemMeta().getPersistentDataContainer().has(originMapLocationZ))) {
            return null;
        }
        Integer origin_x = (Integer)mapItemStack.getItemMeta().getPersistentDataContainer().get(originMapLocationX, PersistentDataType.INTEGER);
        Integer origin_y = (Integer)mapItemStack.getItemMeta().getPersistentDataContainer().get(originMapLocationY, PersistentDataType.INTEGER);
        Integer origin_z = (Integer)mapItemStack.getItemMeta().getPersistentDataContainer().get(originMapLocationZ, PersistentDataType.INTEGER);
        if (origin_x == null || origin_y == null || origin_z == null) {
            return null;
        }
        Location origin = new Location(clicked_item_frame.getWorld(), (double)origin_x.intValue(), (double)origin_y.intValue(), (double)origin_z.intValue());
        return ImageMapEvent.getItemFrame(origin, clicked_item_frame.getFacing());
    }

    @Nullable
    private static ImageMapItem TryGetImageMapItem(ItemStack itemStack) {
        try {
            ImageMapItem imageMapItem = new ImageMapItem(itemStack.clone());
            imageMapItem.setUpThumbnail();
            return imageMapItem;
        }
        catch (Exception e) {
            XLogger.debug("Not a image map: %s", e.getMessage());
            return null;
        }
    }

    private static void HandleBroken(ItemFrame originItemFrame, ImageMapItem imageMapItem) {
        ItemFrame[][] item_frames;
        try {
            item_frames = ImageMapEvent.getItemFrameMatrix(originItemFrame, imageMapItem.getXCount(), imageMapItem.getYCount());
        }
        catch (Exception e) {
            return;
        }
        for (int j = 0; j < imageMapItem.getYCount(); ++j) {
            for (int i = 0; i < imageMapItem.getXCount(); ++i) {
                ItemStack mapItem = item_frames[i][j].getItem();
                byte[] tile_b64 = (byte[])mapItem.getItemMeta().getPersistentDataContainer().get(tileBase64, PersistentDataType.BYTE_ARRAY);
                imageMapItem.setTileBase64(i, j, tile_b64);
                imageMapItem.saveTileToWorldPDC(i, j);
                item_frames[i][j].setItem(new ItemStack(Material.AIR));
                MapMeta meta = (MapMeta)mapItem.getItemMeta();
                MapView mapView = meta.getMapView();
                if (mapView == null) continue;
                int mapviewId = mapView.getId();
                PDCImageManager.removeImageBase64WorldPDC(item_frames[i][j].getWorld(), mapviewId);
            }
        }
    }

    public static ItemFrame[][] getItemFrameMatrix(ItemFrame left_bottom, Integer x, Integer y) throws Exception {
        ItemFrame[][] item_frames = new ItemFrame[x.intValue()][y.intValue()];
        Location corner = left_bottom.getLocation();
        BlockFace facing = left_bottom.getFacing();
        if (facing == BlockFace.UP || facing == BlockFace.DOWN) {
            throw new Exception(Language.imageMapEvent.notSupportedDirection);
        }
        Location top_left = corner.add(0.0, (double)(y - 1), 0.0);
        for (int j = 0; j < y; ++j) {
            for (int i = 0; i < x; ++i) {
                Location loc = top_left.clone();
                if (facing == BlockFace.NORTH) {
                    loc.add((double)(-i), 0.0, 0.0);
                } else if (facing == BlockFace.SOUTH) {
                    loc.add((double)i, 0.0, 0.0);
                } else if (facing == BlockFace.WEST) {
                    loc.add(0.0, 0.0, (double)i);
                } else if (facing == BlockFace.EAST) {
                    loc.add(0.0, 0.0, (double)(-i));
                }
                loc.add(0.0, (double)(-j), 0.0);
                ItemFrame item_frame = ImageMapEvent.getItemFrame(loc, facing);
                if (item_frame == null) {
                    throw new Exception(String.format(Language.imageMapEvent.incompleteItemFrameArray, x, y));
                }
                item_frames[i][j] = item_frame;
            }
        }
        return item_frames;
    }

    private static ItemFrame getItemFrame(Location loc, BlockFace facing) {
        Collection entities = loc.getWorld().getNearbyEntities(loc, 1.0, 1.0, 1.0);
        for (Entity entity : entities) {
            ItemFrame itemFrame;
            if (entity.getLocation().getBlockX() != loc.getBlockX() || entity.getLocation().getBlockY() != loc.getBlockY() || entity.getLocation().getBlockZ() != loc.getBlockZ() || !(entity instanceof ItemFrame) || (itemFrame = (ItemFrame)entity).getFacing() != facing) continue;
            return itemFrame;
        }
        return null;
    }

    public static class ImageMapEventText
    extends ConfigurationPart {
        public String notSupportedDirection = "Don't support place image map in up or down direction";
        public String incompleteItemFrameArray = "Incomplete item frame array need (%d x %d)";
        public String hookEconomyFailed = "Failed to hook economy plugin.";
        public String balanceNotEnough = "Not enough balance to place image map.";
        public String priceInfo = "Matrix size: %d x %d, unit price: %f, total price: %f, your balance: %f";
    }
}

