/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.reColorfulMap.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static BufferedImage loadImage(File imageFile) throws IOException {
        return ImageIO.read(imageFile);
    }

    public static BufferedImage loadImage(String imagePath) throws IOException {
        File imageFile = new File(imagePath);
        return ImageIO.read(imageFile);
    }

    public static void saveImage(BufferedImage image, File outputFile, String format) throws IOException {
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new IOException("Failed to create parent directory: %s".formatted(outputFile.getParentFile()));
        }
        ImageIO.write((RenderedImage)image, format, outputFile);
    }

    public static void saveImage(BufferedImage image, String outputPath, String format) throws IOException {
        File outputFile = new File(outputPath);
        ImageUtils.saveImage(image, outputFile, format);
    }

    public static BufferedImage decodeBase64ToImage(byte[] base64) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(base64);
        return ImageIO.read(bis);
    }

    public static byte[] encodeImageToBase64(BufferedImage image, String format) throws IOException {
        ByteArrayOutputStream ba_os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, format, ba_os);
        return ba_os.toByteArray();
    }

    public static BufferedImage resize(BufferedImage image, float scale) {
        int new_width = (int)((float)image.getWidth() * scale);
        int new_height = (int)((float)image.getHeight() * scale);
        BufferedImage newImage = new BufferedImage(new_width, new_height, 2);
        newImage.getGraphics().drawImage(image, 0, 0, new_width, new_height, null);
        return newImage;
    }

    public static BufferedImage center(BufferedImage image, int width, int height) {
        int image_width = image.getWidth();
        int image_height = image.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, 2);
        newImage.getGraphics().drawImage(image, (width - image_width) / 2, (height - image_height) / 2, null);
        return newImage;
    }

    public static BufferedImage thumb(BufferedImage img) {
        double scale = img.getWidth() > img.getHeight() ? 128.0 / (double)img.getWidth() : 128.0 / (double)img.getHeight();
        return ImageUtils.center(ImageUtils.resize(img, (float)scale), 128, 128);
    }
}

