/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.reColorfulMap.utils;

import cn.lunadeer.reColorfulMap.utils.Common;
import java.util.concurrent.TimeUnit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Scheduler {
    public static Scheduler instance;
    private final JavaPlugin plugin;
    private boolean isPaper = false;

    public Scheduler(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.isPaper = Common.isPaper();
    }

    public static void cancelAll() {
        if (Scheduler.instance.isPaper) {
            Scheduler.instance.plugin.getServer().getGlobalRegionScheduler().cancelTasks((Plugin)Scheduler.instance.plugin);
            Scheduler.instance.plugin.getServer().getGlobalRegionScheduler().cancelTasks((Plugin)Scheduler.instance.plugin);
        } else {
            Scheduler.instance.plugin.getServer().getScheduler().cancelTasks((Plugin)Scheduler.instance.plugin);
        }
    }

    public static void runTaskLater(Runnable task, long delay) {
        if (delay <= 0L) {
            Scheduler.runTask(task);
            return;
        }
        if (Scheduler.instance.isPaper) {
            Scheduler.instance.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)Scheduler.instance.plugin, plugin -> task.run(), delay);
        } else {
            Scheduler.instance.plugin.getServer().getScheduler().runTaskLater((Plugin)Scheduler.instance.plugin, task, delay);
        }
    }

    public static void runTask(Runnable task) {
        if (Scheduler.instance.isPaper) {
            Scheduler.instance.plugin.getServer().getGlobalRegionScheduler().run((Plugin)Scheduler.instance.plugin, plugin -> task.run());
        } else {
            Scheduler.instance.plugin.getServer().getScheduler().runTask((Plugin)Scheduler.instance.plugin, task);
        }
    }

    public static void runTaskRepeat(Runnable task, long delay, long period) {
        if (Scheduler.instance.isPaper) {
            Scheduler.instance.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)Scheduler.instance.plugin, plugin -> task.run(), delay, period);
        } else {
            Scheduler.instance.plugin.getServer().getScheduler().runTaskTimer((Plugin)Scheduler.instance.plugin, task, delay, period);
        }
    }

    public static void runTaskLaterAsync(Runnable task, long delay) {
        if (delay <= 0L) {
            Scheduler.runTaskAsync(task);
            return;
        }
        if (Scheduler.instance.isPaper) {
            Scheduler.instance.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)Scheduler.instance.plugin, plugin -> task.run(), delay * 50L, TimeUnit.MILLISECONDS);
        } else {
            Scheduler.instance.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)Scheduler.instance.plugin, task, delay);
        }
    }

    public static void runTaskAsync(Runnable task) {
        if (Scheduler.instance.isPaper) {
            Scheduler.instance.plugin.getServer().getAsyncScheduler().runNow((Plugin)Scheduler.instance.plugin, plugin -> task.run());
        } else {
            Scheduler.instance.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)Scheduler.instance.plugin, task);
        }
    }

    public static void runTaskRepeatAsync(Runnable task, long delay, long period) {
        if (Scheduler.instance.isPaper) {
            Scheduler.instance.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)Scheduler.instance.plugin, plugin -> task.run(), delay * 50L, period * 50L, TimeUnit.MILLISECONDS);
        } else {
            Scheduler.instance.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)Scheduler.instance.plugin, task, delay, period);
        }
    }
}

