/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.reColorfulMap.utils.VaultConnect;

import cn.lunadeer.reColorfulMap.utils.VaultConnect.Vault;
import cn.lunadeer.reColorfulMap.utils.VaultConnect.Vault2;
import cn.lunadeer.reColorfulMap.utils.VaultConnect.VaultInterface;
import cn.lunadeer.reColorfulMap.utils.XLogger;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VaultConnect
implements Listener {
    public static VaultConnect instance;
    private VaultInterface vaultInstance = null;
    private JavaPlugin plugin;

    public VaultConnect(JavaPlugin plugin) {
        this.plugin = plugin;
        instance = this;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEnable(ServiceRegisterEvent event) {
    }

    public boolean economyAvailable() {
        if (this.vaultInstance == null) {
            if (VaultConnect.foundClass("net.milkbowl.vault.economy.Economy")) {
                this.vaultInstance = new Vault();
            } else if (VaultConnect.foundClass("net.milkbowl.vault2.economy.Economy")) {
                this.vaultInstance = new Vault2();
            } else {
                XLogger.err("No Vault or VaultUnlocked found");
                return false;
            }
            if (!this.vaultInstance.init(this.plugin)) {
                this.vaultInstance = null;
                XLogger.err("No economy plugin available (Vault found but no economy plugin)");
                return false;
            }
        }
        return true;
    }

    public String currencyNamePlural() {
        if (this.economyAvailable()) {
            return this.vaultInstance.currencyNamePlural();
        }
        return "";
    }

    public String currencyNameSingular() {
        if (this.economyAvailable()) {
            return this.vaultInstance.currencyNameSingular();
        }
        return "";
    }

    public void withdrawPlayer(Player player, double amount) {
        if (this.economyAvailable()) {
            this.vaultInstance.withdrawPlayer(player, amount);
        }
    }

    public void depositPlayer(Player player, double amount) {
        if (this.economyAvailable()) {
            this.vaultInstance.depositPlayer(player, amount);
        }
    }

    public double getBalance(Player player) {
        if (this.economyAvailable()) {
            return this.vaultInstance.getBalance(player);
        }
        return 0.0;
    }

    private static boolean foundClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

