/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.reColorfulMap.utils.configuration;

import cn.lunadeer.reColorfulMap.utils.configuration.Comments;
import cn.lunadeer.reColorfulMap.utils.configuration.ConfigurationFile;
import cn.lunadeer.reColorfulMap.utils.configuration.ConfigurationPart;
import cn.lunadeer.reColorfulMap.utils.configuration.PostProcess;
import cn.lunadeer.reColorfulMap.utils.configuration.PreProcess;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationManager {
    public static void load(Class<? extends ConfigurationFile> clazz, File file) throws Exception {
        if (!file.exists()) {
            ConfigurationManager.save(clazz, file);
            return;
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationManager.readConfigurationFile(yaml, clazz, null);
        yaml.options().width(250);
        yaml.save(file);
    }

    public static void load(Class<? extends ConfigurationFile> clazz, File file, String versionFieldName) throws Exception {
        Field versionField = clazz.getField(versionFieldName);
        int currentVersion = versionField.getInt(null);
        ConfigurationManager.load(clazz, file);
        if (versionField.getInt(null) != currentVersion) {
            File backup = new File(file.getParentFile(), file.getName() + ".bak");
            if (backup.exists() && !backup.delete()) {
                throw new Exception("Failed to delete the backup configuration file.");
            }
            if (!file.renameTo(backup)) {
                throw new Exception("Failed to backup the configuration file.");
            }
            clazz.getField(versionFieldName).set(null, currentVersion);
            ConfigurationManager.save(clazz, file);
        }
    }

    public static void save(Class<? extends ConfigurationFile> clazz, File file) throws Exception {
        ConfigurationManager.createIfNotExist(file);
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.options().width(250);
        ConfigurationManager.writeConfigurationFile(yaml, clazz, null);
        yaml.save(file);
    }

    private static void writeConfigurationFile(YamlConfiguration yaml, Class<? extends ConfigurationFile> clazz, String prefix) throws Exception {
        for (Field field : clazz.getFields()) {
            field.setAccessible(true);
            Object key = ConfigurationManager.camelToKebab(field.getName());
            if (prefix != null && !prefix.isEmpty()) {
                key = prefix + "." + (String)key;
            }
            if (ConfigurationPart.class.isAssignableFrom(field.getType())) {
                ConfigurationManager.writeConfigurationPart(yaml, (ConfigurationPart)field.get(null), (String)key);
            } else {
                yaml.set((String)key, field.get(null));
            }
            if (!field.isAnnotationPresent(Comments.class)) continue;
            yaml.setComments((String)key, List.of(field.getAnnotation(Comments.class).value()));
        }
    }

    private static void writeConfigurationPart(YamlConfiguration yaml, ConfigurationPart obj, String key) throws Exception {
        for (Field field : obj.getClass().getFields()) {
            field.setAccessible(true);
            String newKey = key + "." + ConfigurationManager.camelToKebab(field.getName());
            if (ConfigurationPart.class.isAssignableFrom(field.getType())) {
                ConfigurationManager.writeConfigurationPart(yaml, (ConfigurationPart)field.get(obj), newKey);
            } else {
                yaml.set(newKey, field.get(obj));
            }
            if (!field.isAnnotationPresent(Comments.class)) continue;
            yaml.setComments(newKey, List.of(field.getAnnotation(Comments.class).value()));
        }
    }

    private static void createIfNotExist(File file) throws Exception {
        if (file.exists()) {
            return;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new Exception("Failed to create %s directory.".formatted(file.getParentFile().getAbsolutePath()));
        }
        if (!file.createNewFile()) {
            throw new Exception("Failed to create %s file.".formatted(file.getAbsolutePath()));
        }
    }

    private static void readConfigurationFile(YamlConfiguration yaml, Class<? extends ConfigurationFile> clazz, String prefix) throws Exception {
        PrePostProcessInorder processes = ConfigurationManager.getAndSortPrePostProcess(clazz);
        for (Method method : processes.preProcessMethods) {
            method.invoke(null, new Object[0]);
        }
        for (Field field : clazz.getFields()) {
            boolean missingKey;
            field.setAccessible(true);
            Object key = ConfigurationManager.camelToKebab(field.getName());
            if (prefix != null && !prefix.isEmpty()) {
                key = prefix + "." + (String)key;
            }
            boolean bl = missingKey = !yaml.contains((String)key);
            if (missingKey) {
                yaml.createSection((String)key);
                if (field.isAnnotationPresent(Comments.class)) {
                    yaml.setComments((String)key, List.of(field.getAnnotation(Comments.class).value()));
                }
            }
            if (ConfigurationPart.class.isAssignableFrom(field.getType())) {
                ConfigurationManager.readConfigurationPart(yaml, (ConfigurationPart)field.get(null), (String)key);
                continue;
            }
            if (missingKey) {
                yaml.set((String)key, field.get(null));
                continue;
            }
            field.set(null, yaml.get((String)key));
        }
        for (Method method : processes.postProcessMethods) {
            method.invoke(null, new Object[0]);
        }
    }

    private static void readConfigurationPart(YamlConfiguration yaml, ConfigurationPart obj, String key) throws Exception {
        for (Field field : obj.getClass().getFields()) {
            boolean missingKey;
            field.setAccessible(true);
            String newKey = key + "." + ConfigurationManager.camelToKebab(field.getName());
            boolean bl = missingKey = !yaml.contains(newKey);
            if (missingKey) {
                yaml.createSection(newKey);
                if (field.isAnnotationPresent(Comments.class)) {
                    yaml.setComments(newKey, List.of(field.getAnnotation(Comments.class).value()));
                }
            }
            if (ConfigurationPart.class.isAssignableFrom(field.getType())) {
                ConfigurationManager.readConfigurationPart(yaml, (ConfigurationPart)field.get(obj), newKey);
                continue;
            }
            if (missingKey) {
                yaml.set(newKey, field.get(obj));
                continue;
            }
            field.set(obj, yaml.get(newKey));
        }
    }

    private static String camelToKebab(String camel) {
        return camel.replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase();
    }

    private static PrePostProcessInorder getAndSortPrePostProcess(Class<? extends ConfigurationFile> clazz) {
        HashMap<Method, Integer> preProcessMethodsWithPriority = new HashMap<Method, Integer>();
        HashMap<Method, Integer> postProcessMethodsWithPriority = new HashMap<Method, Integer>();
        for (Method method : clazz.getMethods()) {
            if (method.isAnnotationPresent(PreProcess.class)) {
                preProcessMethodsWithPriority.put(method, method.getAnnotation(PreProcess.class).priority());
            }
            if (!method.isAnnotationPresent(PostProcess.class)) continue;
            postProcessMethodsWithPriority.put(method, method.getAnnotation(PostProcess.class).priority());
        }
        PrePostProcessInorder result = new PrePostProcessInorder();
        result.preProcessMethods = new ArrayList(preProcessMethodsWithPriority.keySet());
        result.preProcessMethods.sort(Comparator.comparingInt(preProcessMethodsWithPriority::get));
        result.postProcessMethods = new ArrayList(postProcessMethodsWithPriority.keySet());
        result.postProcessMethods.sort(Comparator.comparingInt(postProcessMethodsWithPriority::get));
        return result;
    }

    private static class PrePostProcessInorder {
        public List<Method> preProcessMethods = new ArrayList<Method>();
        public List<Method> postProcessMethods = new ArrayList<Method>();

        private PrePostProcessInorder() {
        }
    }
}

