/*
 * Decompiled with CFR 0.152.
 */
package tab.bettertab.tabList;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import tab.bettertab.config.BetterTabConfig;
import tab.bettertab.tabList.TabEntry;
import tab.bettertab.tabList.TabUpdater;

public class TabColumn {
    public class_310 client = class_310.method_1551();
    public ArrayList<TabEntry> entries;
    public int width;
    public int totalWidth;
    public int totalHeight;
    public boolean renderColumnNumber = false;
    public int columnNumber;
    private final int columnNumberColor;
    private final BetterTabConfig.ScrollingType scrollingType;

    public TabColumn(ArrayList<TabEntry> entries, int columnNumber) {
        this.columnNumberColor = ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).columnNumberColor.getRGB();
        this.scrollingType = ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).scrollingType;
        this.columnNumber = columnNumber + 1;
        BetterTabConfig.RenderColumnNumberEnum renderColumnNumbers = ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).renderColumnNumbers;
        if (renderColumnNumbers == BetterTabConfig.RenderColumnNumberEnum.Always || renderColumnNumbers == BetterTabConfig.RenderColumnNumberEnum.On_Scroll && (TabUpdater.canScrollLeft || TabUpdater.canScrollRight)) {
            this.renderColumnNumber = true;
        }
        this.entries = new ArrayList<TabEntry>(entries);
        this.width = Collections.max(this.entries.stream().map(entry -> entry.totalWidth).toList());
        this.totalWidth = this.width + 1;
        this.totalHeight = this.entries.stream().mapToInt(entry -> entry.totalHeight).sum() + (this.renderColumnNumber ? 10 : 0);
    }

    public void render(class_332 context, int startX, int startY) {
        int y = startY;
        for (TabEntry entry : this.entries) {
            entry.render(context, startX + 1, y + 1, this.width);
            y += entry.totalHeight;
        }
        if (this.renderColumnNumber && this.scrollingType.equals((Object)BetterTabConfig.ScrollingType.Column)) {
            class_327 class_3272 = this.client.field_1772;
            String string = String.valueOf(this.columnNumber);
            int n = startX + this.width / 2;
            Objects.requireNonNull(this.client.field_1772);
            Objects.requireNonNull(this.client.field_1772);
            context.method_25300(class_3272, string, n, startY + TabUpdater.columnsHeight - 9 + 9 / 2 - 3, this.columnNumberColor);
        }
    }
}

