/*
 * Decompiled with CFR 0.152.
 */
package tab.bettertab.tabList;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_640;
import net.minecraft.class_7532;
import net.minecraft.class_9013;
import net.minecraft.class_9015;
import net.minecraft.class_9022;
import net.minecraft.class_9025;
import tab.bettertab.Tools;
import tab.bettertab.config.BetterTabConfig;
import tab.bettertab.tabList.BadgeManager;

public class TabEntry {
    private class_310 client;
    public boolean validEntry = true;
    private final boolean renderHead;
    private final boolean renderPing;
    private final boolean useNumericPing;
    public int totalWidth;
    public int totalHeight;
    public class_2561 name;
    private List<class_5481> lines;
    public int textWidth;
    public int textHeight;
    private int maxColumnWidth;
    private int textStartX;
    private class_2960 headTexture;
    private int iconY;
    private class_1934 gameMode;
    private List<class_2960> badges;
    private String pingText;
    private int pingWidth;
    private int pingColor;
    private class_2960 pingTexture;
    private boolean renderScore;
    private int scoreLength;
    private class_2561 scoreText;
    private boolean lineEntry;

    public TabEntry(class_310 client, class_640 entry, int maxColumnWidth, class_269 scoreboard, class_266 objective, boolean lineEntry) {
        class_9015 scoreHolder;
        class_9013 readableScoreboardScore;
        this.renderHead = ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).renderHeads;
        this.renderPing = ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).renderPing;
        this.useNumericPing = ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).numericalPing;
        this.textWidth = 0;
        this.textHeight = 0;
        this.textStartX = 0;
        this.iconY = 0;
        this.badges = new ArrayList<class_2960>();
        this.pingWidth = 0;
        this.renderScore = false;
        this.scoreLength = 0;
        this.lineEntry = false;
        if (lineEntry) {
            this.totalWidth = maxColumnWidth;
            Objects.requireNonNull(client.field_1772);
            this.textHeight = 9;
            this.totalHeight = this.textHeight + 2;
            this.lineEntry = true;
            return;
        }
        this.client = client;
        this.maxColumnWidth = maxColumnWidth;
        class_327 textRenderer = client.field_1772;
        this.gameMode = entry.method_2958();
        this.name = Tools.getPlayerName(entry);
        if (this.name == null || this.name.getString().isEmpty()) {
            this.validEntry = false;
            return;
        }
        this.lines = textRenderer.method_1728((class_5348)this.name, maxColumnWidth);
        this.textHeight = textRenderer.method_44378((class_5348)this.name, maxColumnWidth) + (this.lines.size() > 1 ? (this.lines.size() - 1) * 2 : 0);
        this.textWidth = Collections.max(this.lines.stream().map(arg_0 -> ((class_327)textRenderer).method_30880(arg_0)).toList());
        int badgeWidth = 0;
        if (((BetterTabConfig)BetterTabConfig.CONFIG.instance()).renderBadges) {
            this.badges = BadgeManager.getBadges(entry);
            badgeWidth = this.badges.size() * 10;
        }
        if (((BetterTabConfig)BetterTabConfig.CONFIG.instance()).renderScoreboardNumber && objective != null && entry.method_2958() != class_1934.field_9219 && (readableScoreboardScore = scoreboard.method_55430(scoreHolder = class_9015.method_55420((GameProfile)entry.method_2966()), objective)) != null) {
            if (objective.method_1118() == class_274.class_275.field_1471) {
                this.scoreText = class_2561.method_43470((String)String.format(((BetterTabConfig)BetterTabConfig.CONFIG.instance()).healthFormat, readableScoreboardScore.method_55397())).method_27692(class_124.field_1061);
            } else {
                class_9022 numberFormat = objective.method_55380((class_9022)class_9025.field_47568);
                this.scoreText = class_9013.method_55398((class_9013)readableScoreboardScore, (class_9022)numberFormat);
            }
            this.renderScore = true;
            this.scoreLength = client.field_1772.method_27525((class_5348)this.scoreText);
        }
        this.iconY = (this.textHeight - 8) / 2 + 1;
        if (this.renderHead) {
            this.headTexture = entry.method_52810().comp_1626().comp_3627();
        }
        if (this.renderPing) {
            if (this.useNumericPing) {
                this.pingText = String.format(((BetterTabConfig)BetterTabConfig.CONFIG.instance()).numericFormat, entry.method_2959());
                this.pingWidth = textRenderer.method_1727(this.pingText);
                this.pingColor = Tools.numericalColorizer(entry.method_2959());
            } else {
                this.pingWidth = 10;
                this.pingTexture = entry.method_2959() < 0 ? class_2960.method_60656((String)"icon/ping_unknown") : (entry.method_2959() < 150 ? class_2960.method_60656((String)"icon/ping_5") : (entry.method_2959() < 300 ? class_2960.method_60656((String)"icon/ping_4") : (entry.method_2959() < 600 ? class_2960.method_60656((String)"icon/ping_3") : (entry.method_2959() < 1000 ? class_2960.method_60656((String)"icon/ping_2") : class_2960.method_60656((String)"icon/ping_1")))));
            }
        }
        this.textStartX = 2 + (this.renderHead ? 9 : 0) + badgeWidth;
        this.totalWidth = 2 + this.textWidth + badgeWidth + (this.renderHead ? 11 : 0) + (this.scoreLength > 0 || this.pingWidth > 0 ? 5 : 0) + this.scoreLength + this.pingWidth + 2;
        this.totalHeight = 2 + this.textHeight;
    }

    public void render(class_332 context, int x1, int y1, int columnWidth) {
        context.method_25294(x1, y1, x1 + columnWidth, y1 + this.textHeight + 1, ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).cellColor.getRGB());
        if (this.lineEntry) {
            context.method_25294(x1 + 2, y1 + (this.textHeight + 1) / 2, x1 + columnWidth - 2, y1 + (this.textHeight + 1) / 2 + 1, ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).emptyLineColor.getRGB());
            return;
        }
        int iconX = x1 += 2;
        for (class_2960 badge : this.badges) {
            context.method_25290(class_10799.field_56883, badge, iconX, y1 + this.iconY, 0.0f, 0.0f, 8, 8, 8, 8);
            iconX += 10;
        }
        if (this.renderHead) {
            class_7532.method_44445((class_332)context, (class_2960)this.headTexture, (int)iconX, (int)(y1 + this.iconY), (int)8, (boolean)true, (boolean)false, (int)-1);
        }
        context.method_51440(this.client.field_1772, (class_5348)this.name, x1 + this.textStartX, y1 + 2 + (this.lines.size() > 1 ? this.lines.size() - 1 : 0), this.maxColumnWidth, this.gameMode == class_1934.field_9219 ? ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).spectatorColor.getRGB() : ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).nameColor.getRGB(), true);
        if (this.renderScore) {
            context.method_27535(this.client.field_1772, this.scoreText, x1 + columnWidth - this.pingWidth - this.scoreLength - 6, y1 + 2, -1);
        }
        if (this.renderPing) {
            if (this.useNumericPing) {
                context.method_25303(this.client.field_1772, this.pingText, x1 + columnWidth - this.pingWidth - 3, y1 + 2, this.pingColor);
            } else {
                context.method_52706(class_10799.field_56883, this.pingTexture, x1 + columnWidth - 14, y1 + 2, 10, 8);
            }
        }
    }
}

