/*
 * Decompiled with CFR 0.152.
 */
package tab.bettertab.tabList;

import java.util.Objects;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import tab.bettertab.config.BetterTabConfig;
import tab.bettertab.tabList.TabColumn;
import tab.bettertab.tabList.TabUpdater;

public class TabRenderer {
    public static boolean immediatelyUpdate = false;
    private static long scrollIndicatorLast = 0L;
    private static boolean showScrollingIndicator = false;
    private static final int columnNumberColor = ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).columnNumberColor.getRGB();

    public static void render(class_310 client, class_332 context, int scaledWindowWidth, class_269 scoreboard, @Nullable class_266 objective) {
        if (TabUpdater.renderColumns.isEmpty()) {
            return;
        }
        class_327 textRenderer = client.field_1772;
        int x = TabUpdater.startTextX;
        int y = TabUpdater.startBoxY + 5;
        context.method_25294(TabUpdater.startBoxX, TabUpdater.startBoxY, TabUpdater.startBoxX + TabUpdater.totalWidth, TabUpdater.startBoxY + TabUpdater.totalHeight, ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).backgroundColor.getRGB());
        y = TabRenderer.renderHeader(textRenderer, context, y);
        TabRenderer.renderFooter(textRenderer, context);
        if (((BetterTabConfig)BetterTabConfig.CONFIG.instance()).renderScrollIndicator) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - scrollIndicatorLast > (long)((BetterTabConfig)BetterTabConfig.CONFIG.instance()).scrollIndicatorSpeed) {
                showScrollingIndicator = !showScrollingIndicator;
                scrollIndicatorLast = currentTime;
            }
            if (showScrollingIndicator) {
                TabRenderer.renderPageArrows(textRenderer, context, y);
            }
        }
        for (TabColumn column : TabUpdater.renderColumns) {
            column.render(context, x, y);
            x += column.totalWidth;
        }
        if (((BetterTabConfig)BetterTabConfig.CONFIG.instance()).scrollingType.equals((Object)BetterTabConfig.ScrollingType.Page)) {
            context.method_25300(client.field_1772, String.valueOf(TabUpdater.pageNumber), TabUpdater.startBoxX + TabUpdater.totalWidth / 2, TabUpdater.footerStartY - 11, columnNumberColor);
        }
    }

    private static int renderHeader(class_327 textRenderer, class_332 context, int y) {
        for (class_5481 text : TabUpdater.headerList) {
            context.method_35719(textRenderer, text, TabUpdater.startBoxX + TabUpdater.totalWidth / 2, y, -1);
            Objects.requireNonNull(textRenderer);
            y += 9;
        }
        return y;
    }

    private static void renderFooter(class_327 textRenderer, class_332 context) {
        int footerHeight = TabUpdater.footerStartY;
        for (class_5481 text : TabUpdater.footerList) {
            context.method_35719(textRenderer, text, TabUpdater.startBoxX + TabUpdater.totalWidth / 2, footerHeight, -1);
            Objects.requireNonNull(textRenderer);
            footerHeight += 9;
        }
    }

    private static void renderPageArrows(class_327 textRenderer, class_332 context, int y) {
        if (TabUpdater.canScrollLeft) {
            context.method_25300(textRenderer, "<", TabUpdater.startBoxX + 7, y + TabUpdater.columnsHeight / 2 - 4, ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).scrollIndicatorColor.getRGB());
        }
        if (TabUpdater.canScrollRight) {
            context.method_25300(textRenderer, ">", TabUpdater.startBoxX + TabUpdater.totalWidth - 7, y + TabUpdater.columnsHeight / 2 - 4, ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).scrollIndicatorColor.getRGB());
        }
    }
}

