/*
 * Decompiled with CFR 0.152.
 */
package tab.bettertab.tabList;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_640;
import tab.bettertab.BetterTab;
import tab.bettertab.config.BetterTabConfig;
import tab.bettertab.tabList.FakePlayer;
import tab.bettertab.tabList.TabColumn;
import tab.bettertab.tabList.TabEntry;

public class TabUpdater {
    public static ArrayList<TabColumn> renderColumns = new ArrayList();
    public static int totalWidth;
    public static int totalHeight;
    public static int columnsHeight;
    public static int startBoxX;
    public static int startBoxY;
    public static int startTextX;
    public static int startTextY;
    public static boolean canScrollLeft;
    public static boolean canScrollRight;
    private static int atZeroEndIndex;
    private static boolean wasAtZero;
    public static List<class_5481> headerList;
    public static List<class_5481> footerList;
    public static int footerStartY;
    public static int pageNumber;

    public static void update(class_310 client, List<class_640> playerEntries, class_2561 header, class_2561 footer, class_269 scoreboard, class_266 objective) {
        int endIndex;
        if (playerEntries.isEmpty()) {
            renderColumns = new ArrayList();
            return;
        }
        int maxScreenWidth = (int)((float)client.method_22683().method_4486() * ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).maxWidth);
        headerList = ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).renderHeader && header != null ? client.field_1772.method_1728((class_5348)header, maxScreenWidth) : new ArrayList<class_5481>();
        int n = headerList.size();
        Objects.requireNonNull(client.field_1772);
        int headerHeight = 5 + n * 9;
        footerList = ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).renderFooter && footer != null ? client.field_1772.method_1728((class_5348)footer, maxScreenWidth) : new ArrayList<class_5481>();
        int n2 = footerList.size();
        Objects.requireNonNull(client.field_1772);
        int footerHeight = n2 * 9 + 5;
        ArrayList<TabEntry> tabEntries = new ArrayList<TabEntry>();
        int maxColumnWidth = (int)((float)maxScreenWidth * ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).maxColumnWidth);
        int maxColumnHeight = (int)((float)(client.method_22683().method_4502() - headerHeight - footerHeight) * ((BetterTabConfig)BetterTabConfig.CONFIG.instance()).maxColumnHeight);
        for (class_640 entry : playerEntries) {
            TabEntry tabEntry = new TabEntry(client, entry, maxColumnWidth, scoreboard, objective, false);
            if (!tabEntry.validEntry) continue;
            tabEntries.add(tabEntry);
        }
        ArrayList<TabColumn> columns = new ArrayList<TabColumn>();
        ArrayList<TabEntry> columnEntries = new ArrayList<TabEntry>();
        int columnHeight = 0;
        for (TabEntry tabEntry : tabEntries) {
            if (columnHeight + tabEntry.textHeight > maxColumnHeight) {
                columns.add(new TabColumn(columnEntries, columns.size()));
                columnEntries.clear();
                columnHeight = 0;
            }
            columnHeight += tabEntry.textHeight;
            columnEntries.add(tabEntry);
        }
        if (!columnEntries.isEmpty()) {
            columns.add(new TabColumn(columnEntries, columns.size()));
        }
        int startIndex = 0;
        if (((BetterTabConfig)BetterTabConfig.CONFIG.instance()).scrollingType.equals((Object)BetterTabConfig.ScrollingType.Page)) {
            int page = 0;
            BetterTab.tabScroll = Math.max(BetterTab.tabScroll, 0.0);
            while ((double)page <= BetterTab.tabScroll) {
                int lastStart = startIndex;
                startIndex = endIndex;
                int availableWidth = maxScreenWidth - 30;
                while (endIndex < columns.size() && availableWidth - ((TabColumn)columns.get((int)endIndex)).totalWidth > 0) {
                    availableWidth -= ((TabColumn)columns.get((int)endIndex)).totalWidth;
                    ++endIndex;
                }
                if (startIndex == endIndex) {
                    startIndex = lastStart;
                    BetterTab.tabScroll = page - 1;
                    break;
                }
                ++page;
            }
            pageNumber = page;
        } else {
            BetterTab.tabScroll = Math.min(Math.max(0.0, BetterTab.tabScroll), (double)columns.size());
            int availableWidth = maxScreenWidth - 30;
            if (BetterTab.tabScroll == 0.0) {
                for (endIndex = 0; endIndex < columns.size() && availableWidth - ((TabColumn)columns.get((int)endIndex)).totalWidth > 0; ++endIndex) {
                    availableWidth -= ((TabColumn)columns.get((int)endIndex)).totalWidth;
                }
                atZeroEndIndex = endIndex;
                wasAtZero = true;
            } else {
                int scroll;
                if (wasAtZero) {
                    BetterTab.tabScroll = atZeroEndIndex + 1;
                    wasAtZero = false;
                }
                endIndex = scroll;
                for (startIndex = scroll = (int)Math.min(BetterTab.tabScroll, (double)columns.size()); startIndex > 0 && availableWidth - ((TabColumn)columns.get((int)(startIndex - 1))).totalWidth > 0; --startIndex) {
                    availableWidth -= ((TabColumn)columns.get((int)(startIndex - 1))).totalWidth;
                }
                if (startIndex == 0) {
                    BetterTab.tabScroll = 0.0;
                    while (endIndex < columns.size() && availableWidth - ((TabColumn)columns.get((int)endIndex)).totalWidth > 0) {
                        availableWidth -= ((TabColumn)columns.get((int)endIndex)).totalWidth;
                        ++endIndex;
                    }
                }
            }
        }
        renderColumns = new ArrayList(columns.subList(startIndex, endIndex));
        if (renderColumns.size() > 1 && TabUpdater.renderColumns.getLast().totalHeight < TabUpdater.renderColumns.getFirst().totalHeight) {
            TabColumn lastColumn = renderColumns.getLast();
            int fakeEntries = TabUpdater.renderColumns.getFirst().entries.size() - lastColumn.entries.size();
            if (fakeEntries > 0) {
                ArrayList<TabEntry> entries = lastColumn.entries;
                for (int i = 0; i < fakeEntries; ++i) {
                    entries.add(new TabEntry(client, new FakePlayer("empty"), lastColumn.width, scoreboard, objective, true));
                }
                renderColumns.removeLast();
                renderColumns.add(new TabColumn(entries, lastColumn.columnNumber - 1));
            }
        }
        canScrollLeft = startIndex > 0;
        canScrollRight = endIndex < columns.size();
        int offset = (canScrollLeft ? 10 : 0) + (canScrollRight ? 10 : 0);
        int columnsWidth = renderColumns.stream().mapToInt(col -> col.totalWidth).sum();
        int colTotWidth = columnsWidth + offset + 10;
        int serverInfoWidth = Math.max(headerList.isEmpty() ? 0 : Collections.max(headerList.stream().map(arg_0 -> ((class_327)client.field_1772).method_30880(arg_0)).toList()), footerList.isEmpty() ? 0 : Collections.max(footerList.stream().map(arg_0 -> ((class_327)client.field_1772).method_30880(arg_0)).toList())) + 10;
        boolean useColumnWidth = colTotWidth > serverInfoWidth;
        totalWidth = useColumnWidth ? colTotWidth : serverInfoWidth;
        columnsHeight = Collections.max(renderColumns.stream().map(col -> col.totalHeight).toList());
        totalHeight = headerHeight + columnsHeight + footerHeight;
        footerStartY = totalHeight - footerHeight + 13;
        startBoxX = (client.method_22683().method_4486() - totalWidth) / 2;
        startBoxY = 10;
        startTextX = useColumnWidth ? startBoxX + 5 + (canScrollLeft ? 10 : 0) : startBoxX + (totalWidth - columnsWidth) / 2;
        startTextY = headerHeight;
    }
}

