/*
 * Decompiled with CFR 0.152.
 */
package org.lex.wimby.client;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wimby", value={Dist.CLIENT})
public class ClientEvents {
    private static final long UPDATE_INTERVAL_MS = 1000L;
    private static long lastUpdateTime = 0L;
    private static BlockPos lastTargetPos = null;
    private static List<Component> cachedDisplayLines = List.of();
    private static final Map<Block, ResourceLocation> blockIdCache = new LinkedHashMap<Block, ResourceLocation>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Block, ResourceLocation> eldest) {
            return this.size() > 512;
        }
    };

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        boolean shouldUpdate;
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return;
        }
        if (!player.m_6117_() || !player.m_21211_().m_150930_(Items.f_151059_) || player.m_7655_() != InteractionHand.MAIN_HAND) {
            cachedDisplayLines = List.of();
            lastTargetPos = null;
            return;
        }
        long now = System.currentTimeMillis();
        boolean bl = shouldUpdate = now - lastUpdateTime >= 1000L;
        if (shouldUpdate) {
            Vec3 lookVec;
            Vec3 reachVec;
            double reachDistance = Math.min((double)((Integer)mc.f_91066_.m_231984_().m_231551_()).intValue() * 16.0, 64.0);
            Vec3 eyePos = player.m_20299_(1.0f);
            BlockHitResult rayResult = mc.f_91073_.m_45547_(new ClipContext(eyePos, reachVec = eyePos.m_82549_((lookVec = player.m_20252_(1.0f)).m_82490_(reachDistance)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (rayResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos pos = rayResult.m_82425_();
                if (!pos.equals((Object)lastTargetPos) && mc.f_91073_.m_46805_(pos)) {
                    lastTargetPos = pos;
                    lastUpdateTime = now;
                    cachedDisplayLines = ClientEvents.generateDisplayInfo(pos, mc, player);
                }
            } else {
                cachedDisplayLines = List.of();
                lastTargetPos = null;
            }
        }
        if (!cachedDisplayLines.isEmpty()) {
            ClientEvents.drawOverlay(event.getGuiGraphics(), mc.f_91062_, cachedDisplayLines);
        }
    }

    private static List<Component> generateDisplayInfo(BlockPos pos, Minecraft mc, LocalPlayer player) {
        BlockState state = mc.f_91073_.m_8055_(pos);
        Block block = state.m_60734_();
        if (block == Blocks.f_50016_) {
            return List.of();
        }
        ResourceLocation blockId = blockIdCache.computeIfAbsent(block, b -> mc.f_91073_.m_9598_().m_175515_(Registries.f_256747_).m_7981_(b));
        String facing = "";
        for (Property property : state.m_61147_()) {
            if (!(property instanceof DirectionProperty)) continue;
            try {
                facing = ((Direction)state.m_61143_(property)).m_122433_();
            }
            catch (Exception exception) {}
            break;
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237113_((String)("Block Id: " + blockId)));
        lines.add((Component)Component.m_237113_((String)("X: " + pos.m_123341_())));
        lines.add((Component)Component.m_237113_((String)("Y: " + pos.m_123342_())));
        lines.add((Component)Component.m_237113_((String)("Z: " + pos.m_123343_())));
        lines.add((Component)Component.m_237113_((String)("Facing: " + (facing.isEmpty() ? "\"\"" : facing))));
        if (player.m_6144_()) {
            int blockLight = mc.f_91073_.m_45517_(LightLayer.BLOCK, pos);
            int skyLight = mc.f_91073_.m_45517_(LightLayer.SKY, pos);
            int emission = state.m_60791_();
            float hardness = state.m_60800_((BlockGetter)mc.f_91073_, pos);
            lines.add((Component)Component.m_237113_((String)("Block Light: " + blockLight)));
            lines.add((Component)Component.m_237113_((String)("Sky Light: " + skyLight)));
            lines.add((Component)Component.m_237113_((String)("Emission: " + emission)));
            lines.add((Component)Component.m_237113_((String)String.format("Hardness: %.2f", Float.valueOf(hardness))));
            FluidState fluidState = state.m_60819_();
            String materialType = !fluidState.m_76178_() ? fluidState.m_76152_().toString() : (state.m_204336_(BlockTags.f_13035_) ? "Leaves" : (state.m_204336_(BlockTags.f_13106_) ? "Wood" : (block == Blocks.f_50069_ ? "Stone" : "Other")));
            lines.add((Component)Component.m_237113_((String)("Material: " + materialType)));
            for (Property property : state.m_61147_()) {
                String name = property.m_61708_().toLowerCase();
                if (!name.contains("level") && !name.contains("fill") && !name.contains("amount") && !name.contains("cauldron") && !name.contains("composter")) continue;
                try {
                    Comparable value = state.m_61143_(property);
                    lines.add((Component)Component.m_237113_((String)(name + ": " + value)));
                }
                catch (Exception exception) {}
            }
        }
        return lines;
    }

    private static void drawOverlay(GuiGraphics guiGraphics, Font font, List<Component> lines) {
        int x = 10;
        int y = 10;
        Objects.requireNonNull(font);
        int lineHeight = 9 + 2;
        for (Component line : lines) {
            guiGraphics.m_280614_(font, line, x, y, 0xFFFFFF, true);
            y += lineHeight;
        }
    }
}

