/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.server_sided_portals.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;

public record PermissionTweak(int permission, List<String> players, List<String> teams, boolean whitelist) {
    public static final Codec<PermissionTweak> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("permission", (Object)5).forGetter(PermissionTweak::permission), (App)Codec.STRING.listOf().optionalFieldOf("players", List.of()).forGetter(PermissionTweak::players), (App)Codec.STRING.listOf().optionalFieldOf("teams", List.of()).forGetter(PermissionTweak::teams), (App)Codec.BOOL.optionalFieldOf("whitelist", (Object)false).forGetter(PermissionTweak::whitelist)).apply((Applicative)instance, PermissionTweak::new));
    public static final PermissionTweak DEFAULT_PERMISSION = new PermissionTweak(5, Collections.emptyList(), Collections.emptyList(), false);

    public boolean isAllowed(ServerPlayer player) {
        return this.whitelist() == (player.getPermissionLevel() >= this.permission() || this.players().stream().anyMatch(profile -> player.getStringUUID().equalsIgnoreCase((String)profile)) || player.getTeam() != null && this.teams().stream().anyMatch(team -> player.getTeam().getName().equals(team)));
    }
}

