/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.server_sided_portals.handler;

import it.crystalnest.server_sided_portals.api.CustomPortalChecker;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.portal.PortalShape;

public abstract class ItemUseHandler {
    protected boolean handle(Level level, Player player, InteractionHand hand, BlockPos pos, Direction face) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!player.isSpectator()) {
                ResourceKey<Level> dimension;
                Optional portal;
                Optional<TagKey> frame = CustomPortalChecker.getDimensionsWithCustomPortal(server).stream().map(CustomPortalChecker::getCustomPortalFrameTag).filter(tag -> server.getBlockState(pos).is(tag)).findAny();
                Optional<TagKey> igniter = CustomPortalChecker.getDimensionsWithCustomPortal(server).stream().map(CustomPortalChecker::getCustomPortalIgniterTag).filter(tag -> player.getItemInHand(hand).is(tag)).findAny();
                if (frame.isPresent() && igniter.isPresent() && (portal = PortalShape.findEmptyPortalShape((LevelAccessor)server, (BlockPos)pos.relative(face), (Direction.Axis)Direction.Axis.X)).isPresent() && CustomPortalChecker.getCustomPortalFrameTag(dimension = ((CustomPortalChecker)portal.get()).dimension()).equals((Object)frame.get()) && CustomPortalChecker.getCustomPortalIgniterTag(dimension).equals((Object)igniter.get())) {
                    player.swing(hand, true);
                    ((PortalShape)portal.get()).createPortalBlocks((LevelAccessor)level);
                    return true;
                }
            }
        }
        return false;
    }
}

