/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.server_sided_portals.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.crystalnest.server_sided_portals.api.CustomPortalChecker;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BaseFireBlock.class})
public abstract class BaseFireBlockMixin {
    @Unique
    private static boolean checkCustomPortalFrame(Level level, BlockPos pos) {
        ServerLevel server;
        return level instanceof ServerLevel && CustomPortalChecker.getDimensionsWithCustomPortal(server = (ServerLevel)level).stream().map(CustomPortalChecker::getCustomPortalFrameTag).anyMatch(tag -> level.getBlockState(pos).is(tag));
    }

    @ModifyExpressionValue(method={"isPortal"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/BaseFireBlock;inPortalDimension(Lnet/minecraft/world/level/Level;)Z")})
    private static boolean modifyInPortalDimension$isPortal(boolean original, Level level) {
        return original || CustomPortalChecker.hasCustomPortalFrame(level);
    }

    @WrapOperation(method={"isPortal"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;")})
    private static BlockState wrapGetBlockState(Level instance, BlockPos pos, Operation<BlockState> original) {
        return BaseFireBlockMixin.checkCustomPortalFrame(instance, pos) ? Blocks.OBSIDIAN.defaultBlockState() : (BlockState)original.call(new Object[]{instance, pos});
    }

    @ModifyExpressionValue(method={"onPlace"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/BaseFireBlock;inPortalDimension(Lnet/minecraft/world/level/Level;)Z")})
    private boolean modifyInPortalDimension$onPlace(boolean original, BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        return original || CustomPortalChecker.hasCustomPortalFrame(level);
    }

    @WrapOperation(method={"onPlace"}, at={@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z")})
    private boolean wrapIsPresent(Optional<PortalShape> instance, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{instance}) != false && instance.isPresent() && !CustomPortalChecker.hasCustomPortalIgniter(((CustomPortalChecker)instance.get()).dimension());
    }
}

