/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.server_sided_portals.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import it.crystalnest.server_sided_portals.Constants;
import it.crystalnest.server_sided_portals.api.CustomPortalChecker;
import it.crystalnest.server_sided_portals.api.DimensionTweak;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PortalShape.class})
public abstract class PortalShapeMixin
implements CustomPortalChecker {
    @Unique
    private boolean finalized = false;
    @Unique
    private ResourceKey<Level> destination = Level.OVERWORLD;
    @Unique
    private ResourceKey<Level> dimension = Level.OVERWORLD;

    @Shadow
    private static boolean isEmpty(BlockState state) {
        throw new UnsupportedOperationException("Tried to call a dummy body of a shadowed method: PortalShape#isEmpty(BlockState)");
    }

    @ModifyReturnValue(method={"findAnyShape"}, at={@At(value="RETURN")})
    private static PortalShape modifyFindAnyShape(PortalShape original, BlockGetter level, BlockPos pos, Direction.Axis axis) {
        if (level instanceof ServerLevel) {
            Direction direction;
            ServerLevel serverLevel = (ServerLevel)level;
            Direction direction2 = direction = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            if (original.isValid()) {
                DimensionTweak tweak = Constants.getTweak((ResourceKey<Level>)Level.NETHER);
                if (serverLevel.dimension() == Level.NETHER || tweak.connection() == serverLevel.dimension()) {
                    ((CustomPortalChecker)original).setInfos((ResourceKey<Level>)Level.NETHER, serverLevel.dimension() == Level.NETHER ? tweak.connection() : Level.NETHER);
                    return original;
                }
                return new PortalShape(axis, 0, direction, pos, 0, 0);
            }
            int width = 0;
            BlockPos bottomLeft = null;
            for (ResourceKey<Level> dimension : CustomPortalChecker.getDimensionsWithCustomPortal(serverLevel)) {
                TagKey<Block> frameBlock;
                if (dimension != serverLevel.dimension() && serverLevel.dimension() != Constants.getTweak(dimension).connection() || (bottomLeft = PortalShapeMixin.calculateBottomLeftForCustomDimension(level, direction, pos, frameBlock = CustomPortalChecker.getCustomPortalFrameTag(dimension))) == null || (width = PortalShapeMixin.calculateWidthForCustomDimension(level, bottomLeft, direction, frameBlock)) <= 0) continue;
                MutableInt portalBlocks = new MutableInt();
                PortalShape portal = new PortalShape(axis, portalBlocks.getValue().intValue(), direction, bottomLeft, width, PortalShapeMixin.calculateHeightForCustomDimension(level, bottomLeft, direction, width, portalBlocks, frameBlock));
                if (portal.isValid()) {
                    ((CustomPortalChecker)portal).setInfos(dimension, serverLevel.dimension() == dimension ? Constants.getTweak(dimension).connection() : dimension);
                }
                return portal;
            }
            if (bottomLeft == null) {
                return new PortalShape(axis, 0, direction, pos, 0, 0);
            }
            if (width == 0) {
                return new PortalShape(axis, 0, direction, bottomLeft, 0, 0);
            }
        }
        return original;
    }

    @Unique
    @Nullable
    private static BlockPos calculateBottomLeftForCustomDimension(BlockGetter level, Direction direction, BlockPos pos, TagKey<Block> frameBlock) {
        int i = Math.max(level.getMinY(), pos.getY() - 21);
        while (pos.getY() > i && PortalShapeMixin.isEmpty(level.getBlockState(pos.below()))) {
            pos = pos.below();
        }
        Direction dir = direction.getOpposite();
        int j = PortalShapeMixin.getDistanceUntilEdgeAboveFrameForCustomDimension(level, pos, dir, frameBlock) - 1;
        return j < 0 ? null : pos.relative(dir, j);
    }

    @Unique
    private static int calculateWidthForCustomDimension(BlockGetter level, BlockPos pos, Direction direction, TagKey<Block> frameBlock) {
        int i = PortalShapeMixin.getDistanceUntilEdgeAboveFrameForCustomDimension(level, pos, direction, frameBlock);
        return i >= 2 && i <= 21 ? i : 0;
    }

    @Unique
    private static int getDistanceUntilEdgeAboveFrameForCustomDimension(BlockGetter level, BlockPos pos, Direction direction, TagKey<Block> frameBlock) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= 21; ++i) {
            BlockState state = level.getBlockState((BlockPos)mutablePos.set((Vec3i)pos).move(direction, i));
            if (!PortalShapeMixin.isEmpty(state)) {
                if (!state.is(frameBlock)) break;
                return i;
            }
            if (!level.getBlockState((BlockPos)mutablePos.move(Direction.DOWN)).is(frameBlock)) break;
        }
        return 0;
    }

    @Unique
    private static int calculateHeightForCustomDimension(BlockGetter level, BlockPos pos, Direction direction, int width, MutableInt portalBlocks, TagKey<Block> frameBlock) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int i = PortalShapeMixin.getDistanceUntilTopForCustomDimension(level, pos, direction, mutablePos, width, portalBlocks, frameBlock);
        return i >= 3 && i <= 21 && PortalShapeMixin.hasTopFrameForCustomDimension(level, pos, direction, mutablePos, width, i, frameBlock) ? i : 0;
    }

    @Unique
    private static int getDistanceUntilTopForCustomDimension(BlockGetter level, BlockPos pos, Direction direction, BlockPos.MutableBlockPos checkPos, int width, MutableInt portalBlocks, TagKey<Block> frameBlock) {
        for (int i = 0; i < 21; ++i) {
            checkPos.set((Vec3i)pos).move(Direction.UP, i).move(direction, -1);
            if (!level.getBlockState((BlockPos)checkPos).is(frameBlock)) {
                return i;
            }
            checkPos.set((Vec3i)pos).move(Direction.UP, i).move(direction, width);
            if (!level.getBlockState((BlockPos)checkPos).is(frameBlock)) {
                return i;
            }
            for (int j = 0; j < width; ++j) {
                checkPos.set((Vec3i)pos).move(Direction.UP, i).move(direction, j);
                BlockState blockstate = level.getBlockState((BlockPos)checkPos);
                if (!PortalShapeMixin.isEmpty(blockstate)) {
                    return i;
                }
                if (!blockstate.is(Blocks.NETHER_PORTAL)) continue;
                portalBlocks.increment();
            }
        }
        return 21;
    }

    @Unique
    private static boolean hasTopFrameForCustomDimension(BlockGetter level, BlockPos pos, Direction direction, BlockPos.MutableBlockPos checkPos, int width, int distanceUntilTop, TagKey<Block> frameBlock) {
        for (int i = 0; i < width; ++i) {
            BlockPos.MutableBlockPos mutablePos = checkPos.set((Vec3i)pos).move(Direction.UP, distanceUntilTop).move(direction, i);
            if (level.getBlockState((BlockPos)mutablePos).is(frameBlock)) continue;
            return false;
        }
        return true;
    }

    @Shadow
    public abstract boolean isValid();

    @Override
    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    @Override
    public ResourceKey<Level> destination() {
        return this.destination;
    }

    @Override
    public void setInfos(ResourceKey<Level> dimension, ResourceKey<Level> destination) throws IllegalStateException {
        if (this.finalized) {
            throw new IllegalStateException("Portal dimension was already set");
        }
        this.dimension = dimension;
        this.destination = destination;
        this.finalized = true;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void finalize(Direction.Axis axis, int numPortalBlocks, Direction direction, BlockPos bottomLeft, int width, int height, CallbackInfo ci) {
        if (!this.isValid()) {
            this.setInfos((ResourceKey<Level>)Level.OVERWORLD, (ResourceKey<Level>)Level.OVERWORLD);
        }
    }
}

