/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.server_sided_portals.api;

import it.crystalnest.server_sided_portals.Constants;
import it.crystalnest.server_sided_portals.api.DimensionTweak;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2423;
import net.minecraft.class_2424;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public interface CustomPortalChecker {
    public static CustomPortalChecker getPortalChecker(class_1937 level, class_2338 pos) {
        return (CustomPortalChecker)new class_2424((class_1936)level, pos, level.method_8320(pos).method_28500((class_2769)class_2423.field_11310).orElse(class_2350.class_2351.field_11048));
    }

    public static class_5321<class_1937> getPortalDimension(class_1937 level, class_2338 pos) {
        return CustomPortalChecker.getPortalChecker(level, pos).dimension();
    }

    public static boolean isPortalForDimension(class_1937 level, class_2338 pos, class_5321<class_1937> dimension) {
        return CustomPortalChecker.getPortalDimension(level, pos) == dimension;
    }

    public static boolean isPortalForDimension(class_1937 level, class_2338 pos, class_2960 dimension) {
        return CustomPortalChecker.getPortalDimension(level, pos).method_29177().equals((Object)dimension);
    }

    public static class_5321<class_1937> getPortalDestination(class_1937 level, class_2338 pos) {
        return CustomPortalChecker.getPortalChecker(level, pos).destination();
    }

    public static boolean isPortalGoingTo(class_1937 level, class_2338 pos, class_5321<class_1937> dimension) {
        return CustomPortalChecker.getPortalDestination(level, pos) == dimension;
    }

    public static boolean isPortalGoingTo(class_1937 level, class_2338 pos, class_2960 dimension) {
        return CustomPortalChecker.getPortalDestination(level, pos).method_29177().equals((Object)dimension);
    }

    public static boolean isCustomPortal(class_1937 level, class_2338 pos) {
        return CustomPortalChecker.hasCustomPortalFrame(CustomPortalChecker.getPortalDimension(level, pos));
    }

    public static List<class_5321<class_1937>> getDimensionsWithCustomPortal(class_3218 level) {
        return level.method_8503().method_29435().stream().filter(CustomPortalChecker::hasCustomPortalFrame).toList();
    }

    public static boolean hasCustomPortalFrame(class_1937 level) {
        return CustomPortalChecker.hasCustomPortalFrame((class_5321<class_1937>)level.method_27983());
    }

    public static boolean hasCustomPortalFrame(class_5321<class_1937> dimension) {
        return class_7923.field_41175.method_40266(CustomPortalChecker.getCustomPortalFrameTag(dimension)).isPresent();
    }

    public static class_6862<class_2248> getCustomPortalFrameTag(class_5321<class_1937> dimension) {
        return class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)dimension.method_29177().method_12836(), (String)(dimension.method_29177().method_12832() + "_portal_frame")));
    }

    public static class_2248 getCustomPortalFrameBlock(class_1937 level) {
        return class_7923.field_41175.method_40266(CustomPortalChecker.getCustomPortalFrameTag((class_5321<class_1937>)level.method_27983())).map(holders -> (class_2248)holders.method_40243(level.method_8409()).orElse(class_6880.method_40223((Object)class_2246.field_10540)).comp_349()).orElse(class_2246.field_10540);
    }

    public static boolean hasCustomPortalIgniter(class_1937 level) {
        return CustomPortalChecker.hasCustomPortalIgniter((class_5321<class_1937>)level.method_27983());
    }

    public static boolean hasCustomPortalIgniter(class_5321<class_1937> dimension) {
        return class_7923.field_41178.method_40266(CustomPortalChecker.getCustomPortalIgniterTag(dimension)).isPresent();
    }

    public static class_6862<class_1792> getCustomPortalIgniterTag(class_5321<class_1937> dimension) {
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)dimension.method_29177().method_12836(), (String)(dimension.method_29177().method_12832() + "_portal_igniter")));
    }

    public static Optional<class_6885.class_6888<class_1792>> getCustomPortalIgniterItems(class_5321<class_1937> dimension) {
        return class_7923.field_41178.method_40266(CustomPortalChecker.getCustomPortalIgniterTag(dimension));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean cannotTravel(class_1297 entity, class_5321<class_1937> dimension) {
        DimensionTweak dimensionTweak = Constants.DIMENSION_TWEAKS.get(dimension);
        if (dimensionTweak == null) return false;
        if (!(entity instanceof class_3222)) return false;
        class_3222 player = (class_3222)entity;
        if (dimensionTweak.permission().isAllowed(player)) return false;
        return true;
    }

    public class_5321<class_1937> dimension();

    public class_5321<class_1937> destination();
}

