/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.server_sided_portals.mixin;

import it.crystalnest.server_sided_portals.Constants;
import it.crystalnest.server_sided_portals.api.CustomPortalChecker;
import it.crystalnest.server_sided_portals.api.DimensionTweak;
import it.crystalnest.server_sided_portals.platform.Services;
import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2424;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2424.class})
public abstract class PortalShapeMixin
implements CustomPortalChecker {
    @Final
    @Shadow
    private class_1936 field_11318;
    @Final
    @Shadow
    private class_2350 field_11314;
    @Shadow
    private int field_11313;
    @Shadow
    @Nullable
    private class_2338 field_11316;
    @Final
    @Shadow
    private int field_11311;
    @Shadow
    private int field_11312;
    @Unique
    private class_5321<class_1937> destination = class_1937.field_25179;
    @Unique
    private class_5321<class_1937> dimension = class_1937.field_25179;

    @Shadow
    private static boolean method_10359(class_2680 state) {
        throw new UnsupportedOperationException("Tried to call a dummy body of a shadowed method: PortalShape#isEmpty(BlockState)");
    }

    @Shadow
    public abstract boolean method_10360();

    @Mutable
    @Accessor(value="width")
    protected abstract void setWidth(int var1);

    @Override
    public class_5321<class_1937> dimension() {
        return this.dimension;
    }

    @Override
    public class_5321<class_1937> destination() {
        return this.destination;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction$Axis;)V"}, at={@At(value="TAIL")})
    private void onInit(class_1936 level, class_2338 pos, class_2350.class_2351 axis, CallbackInfo ci) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            Object bnShape = null;
            if (Services.PLATFORM.isModLoaded("betternether")) {
                try {
                    Constants.LOGGER.debug("Attempting to nullify field 'bn_shape' added by mod 'betternether'...");
                    bnShape = this.getClass().getDeclaredField("bn_shape").get(this);
                    this.getClass().getDeclaredField("bn_shape").set(this, null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    Constants.LOGGER.error("Failed to nullify field 'bn_shape' added by mod 'betternether'", (Throwable)e);
                    Constants.LOGGER.debug("Available fields for PortalShape were:");
                    for (Field field : this.getClass().getDeclaredFields()) {
                        Constants.LOGGER.debug(field.getName());
                    }
                }
            }
            if (this.method_10360()) {
                DimensionTweak tweak = Constants.getTweak((class_5321<class_1937>)class_1937.field_25180);
                if (serverLevel.method_27983() == class_1937.field_25180 || tweak.connection() == serverLevel.method_27983()) {
                    this.dimension = class_1937.field_25180;
                    this.destination = serverLevel.method_27983() == class_1937.field_25180 ? tweak.connection() : class_1937.field_25180;
                } else {
                    this.field_11316 = null;
                    this.setWidth(1);
                    this.field_11312 = 1;
                }
            } else {
                for (class_5321<class_1937> dim : CustomPortalChecker.getDimensionsWithCustomPortal(serverLevel)) {
                    if (dim != serverLevel.method_27983() && serverLevel.method_27983() != Constants.getTweak(dim).connection()) continue;
                    class_6862<class_2248> frameBlock = CustomPortalChecker.getCustomPortalFrameTag(dim);
                    this.field_11316 = this.calculateBottomLeftForCustomDimension(pos, frameBlock);
                    if (this.field_11316 == null) continue;
                    this.setWidth(this.calculateWidthForCustomDimension(frameBlock));
                    if (this.field_11311 <= 0) continue;
                    this.field_11312 = this.calculateHeightForCustomDimension(frameBlock);
                    this.dimension = dim;
                    this.destination = serverLevel.method_27983() == dim ? Constants.getTweak(dim).connection() : dim;
                    break;
                }
                if (this.field_11316 == null) {
                    this.field_11316 = pos;
                    this.setWidth(1);
                    this.field_11312 = 1;
                }
            }
            if (bnShape != null && this.dimension == class_1937.field_25180 && (serverLevel.method_27983() == class_1937.field_25179 || serverLevel.method_27983() == class_1937.field_25180)) {
                try {
                    Constants.LOGGER.debug("Attempting to restore field 'bn_shape' added by mod 'betternether'...");
                    this.getClass().getDeclaredField("bn_shape").set(this, bnShape);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    Constants.LOGGER.error("Failed to restore field 'bn_shape' added by mod 'betternether'", (Throwable)e);
                }
            }
        }
    }

    @Unique
    @Nullable
    private class_2338 calculateBottomLeftForCustomDimension(class_2338 pos, class_6862<class_2248> frameBlock) {
        int i = Math.max(this.field_11318.method_31607(), pos.method_10264() - 21);
        while (pos.method_10264() > i && PortalShapeMixin.method_10359(this.field_11318.method_8320(pos.method_10074()))) {
            pos = pos.method_10074();
        }
        class_2350 direction = this.field_11314.method_10153();
        int j = this.getDistanceUntilEdgeAboveFrameForCustomDimension(frameBlock, pos, direction) - 1;
        return j < 0 ? null : pos.method_10079(direction, j);
    }

    @Unique
    private int calculateWidthForCustomDimension(class_6862<class_2248> frameBlock) {
        int i = this.getDistanceUntilEdgeAboveFrameForCustomDimension(frameBlock, this.field_11316, this.field_11314);
        return i >= 2 && i <= 21 ? i : 0;
    }

    @Unique
    private int getDistanceUntilEdgeAboveFrameForCustomDimension(class_6862<class_2248> frameBlock, class_2338 pos, class_2350 direction) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int i = 0; i <= 21; ++i) {
            class_2680 state = this.field_11318.method_8320((class_2338)mutablePos.method_10101((class_2382)pos).method_10104(direction, i));
            if (!PortalShapeMixin.method_10359(state)) {
                if (!state.method_26164(frameBlock)) break;
                return i;
            }
            if (!this.field_11318.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11033)).method_26164(frameBlock)) break;
        }
        return 0;
    }

    @Unique
    private int calculateHeightForCustomDimension(class_6862<class_2248> frameBlock) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        int i = this.getDistanceUntilTopForCustomDimension(frameBlock, pos);
        return i >= 3 && i <= 21 && this.hasTopFrameForCustomDimension(frameBlock, pos, i) ? i : 0;
    }

    @Unique
    private boolean hasTopFrameForCustomDimension(class_6862<class_2248> frameBlock, class_2338.class_2339 pos, int height) {
        for (int i = 0; i < this.field_11311; ++i) {
            class_2338.class_2339 mutablePos = pos.method_10101((class_2382)Objects.requireNonNull(this.field_11316)).method_10104(class_2350.field_11036, height).method_10104(this.field_11314, i);
            if (this.field_11318.method_8320((class_2338)mutablePos).method_26164(frameBlock)) continue;
            return false;
        }
        return true;
    }

    @Unique
    private int getDistanceUntilTopForCustomDimension(class_6862<class_2248> frameBlock, class_2338.class_2339 pos) {
        for (int i = 0; i < 21; ++i) {
            pos.method_10101((class_2382)Objects.requireNonNull(this.field_11316)).method_10104(class_2350.field_11036, i).method_10104(this.field_11314, -1);
            if (!this.field_11318.method_8320((class_2338)pos).method_26164(frameBlock)) {
                return i;
            }
            pos.method_10101((class_2382)this.field_11316).method_10104(class_2350.field_11036, i).method_10104(this.field_11314, this.field_11311);
            if (!this.field_11318.method_8320((class_2338)pos).method_26164(frameBlock)) {
                return i;
            }
            for (int j = 0; j < this.field_11311; ++j) {
                pos.method_10101((class_2382)this.field_11316).method_10104(class_2350.field_11036, i).method_10104(this.field_11314, j);
                class_2680 blockstate = this.field_11318.method_8320((class_2338)pos);
                if (!PortalShapeMixin.method_10359(blockstate)) {
                    return i;
                }
                if (!blockstate.method_27852(class_2246.field_10316)) continue;
                ++this.field_11313;
            }
        }
        return 21;
    }
}

