/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.server_sided_portals.api;

import it.crystalnest.server_sided_portals.Constants;
import it.crystalnest.server_sided_portals.api.DimensionTweak;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalShape;
import org.jetbrains.annotations.ApiStatus;

public interface CustomPortalChecker {
    public static CustomPortalChecker getPortalChecker(Level level, BlockPos pos) {
        return (CustomPortalChecker)PortalShape.findAnyShape((BlockGetter)level, (BlockPos)pos, (Direction.Axis)level.getBlockState(pos).getOptionalValue((Property)NetherPortalBlock.AXIS).orElse(Direction.Axis.X));
    }

    public static ResourceKey<Level> getPortalDimension(Level level, BlockPos pos) {
        return CustomPortalChecker.getPortalChecker(level, pos).dimension();
    }

    public static boolean isPortalForDimension(Level level, BlockPos pos, ResourceKey<Level> dimension) {
        return CustomPortalChecker.getPortalDimension(level, pos) == dimension;
    }

    public static boolean isPortalForDimension(Level level, BlockPos pos, ResourceLocation dimension) {
        return CustomPortalChecker.getPortalDimension(level, pos).location().equals((Object)dimension);
    }

    public static ResourceKey<Level> getPortalDestination(Level level, BlockPos pos) {
        return CustomPortalChecker.getPortalChecker(level, pos).destination();
    }

    public static boolean isPortalGoingTo(Level level, BlockPos pos, ResourceKey<Level> dimension) {
        return CustomPortalChecker.getPortalDestination(level, pos) == dimension;
    }

    public static boolean isPortalGoingTo(Level level, BlockPos pos, ResourceLocation dimension) {
        return CustomPortalChecker.getPortalDestination(level, pos).location().equals((Object)dimension);
    }

    public static boolean isCustomPortal(Level level, BlockPos pos) {
        return CustomPortalChecker.hasCustomPortalFrame(CustomPortalChecker.getPortalDimension(level, pos));
    }

    public static List<ResourceKey<Level>> getDimensionsWithCustomPortal(ServerLevel level) {
        return level.getServer().levelKeys().stream().filter(CustomPortalChecker::hasCustomPortalFrame).toList();
    }

    public static boolean hasCustomPortalFrame(Level level) {
        return CustomPortalChecker.hasCustomPortalFrame((ResourceKey<Level>)level.dimension());
    }

    public static boolean hasCustomPortalFrame(ResourceKey<Level> dimension) {
        return BuiltInRegistries.BLOCK.get(CustomPortalChecker.getCustomPortalFrameTag(dimension)).isPresent();
    }

    public static TagKey<Block> getCustomPortalFrameTag(ResourceKey<Level> dimension) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)dimension.location().getNamespace(), (String)(dimension.location().getPath() + "_portal_frame")));
    }

    public static Block getCustomPortalFrameBlock(Level level) {
        return BuiltInRegistries.BLOCK.get(CustomPortalChecker.getCustomPortalFrameTag((ResourceKey<Level>)level.dimension())).map(holders -> (Block)holders.getRandomElement(level.getRandom()).orElse(Holder.direct((Object)Blocks.OBSIDIAN)).value()).orElse(Blocks.OBSIDIAN);
    }

    public static boolean hasCustomPortalIgniter(Level level) {
        return CustomPortalChecker.hasCustomPortalIgniter((ResourceKey<Level>)level.dimension());
    }

    public static boolean hasCustomPortalIgniter(ResourceKey<Level> dimension) {
        return BuiltInRegistries.ITEM.get(CustomPortalChecker.getCustomPortalIgniterTag(dimension)).isPresent();
    }

    public static TagKey<Item> getCustomPortalIgniterTag(ResourceKey<Level> dimension) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)dimension.location().getNamespace(), (String)(dimension.location().getPath() + "_portal_igniter")));
    }

    public static Optional<HolderSet.Named<Item>> getCustomPortalIgniterItems(ResourceKey<Level> dimension) {
        return BuiltInRegistries.ITEM.get(CustomPortalChecker.getCustomPortalIgniterTag(dimension));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean cannotTravel(Entity entity, ResourceKey<Level> dimension) {
        DimensionTweak dimensionTweak = Constants.DIMENSION_TWEAKS.get(dimension);
        if (dimensionTweak == null) return false;
        if (!(entity instanceof ServerPlayer)) return false;
        ServerPlayer player = (ServerPlayer)entity;
        if (dimensionTweak.permission().isAllowed(player)) return false;
        return true;
    }

    public ResourceKey<Level> dimension();

    public ResourceKey<Level> destination();

    @ApiStatus.Internal
    public void setInfos(ResourceKey<Level> var1, ResourceKey<Level> var2) throws IllegalStateException;
}

