/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.server_sided_portals.handler;

import it.crystalnest.server_sided_portals.api.CustomPortalChecker;
import it.crystalnest.server_sided_portals.handler.GamemodeChangeHandler;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="server_sided_portals")
public final class DimensionTravelHandler
extends GamemodeChangeHandler {
    private static final DimensionTravelHandler INSTANCE = new DimensionTravelHandler();

    private DimensionTravelHandler() {
    }

    @SubscribeEvent
    public static void handle(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            INSTANCE.handle(player2, (ResourceKey<Level>)event.getTo());
        }
    }

    @SubscribeEvent
    public static void handle(EntityTravelToDimensionEvent event) {
        if (CustomPortalChecker.cannotTravel(event.getEntity(), (ResourceKey<Level>)event.getDimension())) {
            event.setCanceled(true);
        }
    }
}

