/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.server_sided_portals.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.crystalnest.server_sided_portals.Constants;
import it.crystalnest.server_sided_portals.api.CustomPortalChecker;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalForcer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={PortalForcer.class})
public abstract class PortalForcerMixin {
    @Final
    @Shadow
    private ServerLevel level;

    @Unique
    private BlockState getCorrectBlockState(BlockState state) {
        if (state.is(Blocks.OBSIDIAN)) {
            if (CustomPortalChecker.hasCustomPortalFrame((Level)this.level)) {
                return CustomPortalChecker.getCustomPortalFrameBlock((Level)this.level).defaultBlockState();
            }
            ResourceKey<Level> origin = Constants.DIMENSION_ORIGIN_THREAD.get();
            if (CustomPortalChecker.hasCustomPortalFrame(origin)) {
                return CustomPortalChecker.getCustomPortalFrameBlock((Level)Objects.requireNonNull(this.level.getServer().getLevel(origin))).defaultBlockState();
            }
            return CustomPortalChecker.getCustomPortalFrameBlock((Level)this.level).defaultBlockState();
        }
        return state;
    }

    @ModifyArg(method={"createPortal"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z"), index=1)
    private BlockState modifySetBlockStateNoFlags$createPortal(BlockState state) {
        return this.getCorrectBlockState(state);
    }

    @ModifyArg(method={"createPortal"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", ordinal=0), index=1)
    private BlockState modifyArgSetBlockStateWithFlags$createPortal(BlockState state) {
        return this.getCorrectBlockState(state);
    }

    @WrapOperation(method={"findClosestPortalPosition"}, at={@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", ordinal=1)})
    private Stream<BlockPos> wrapFilter(Stream<BlockPos> instance, Predicate<? super BlockPos> predicate, Operation<Stream<BlockPos>> original) {
        return ((Stream)original.call(new Object[]{instance, predicate})).filter(pos -> CustomPortalChecker.isPortalGoingTo((Level)this.level, pos, Constants.DIMENSION_ORIGIN_THREAD.get()));
    }
}

