/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.server_sided_portals.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import it.crystalnest.server_sided_portals.Constants;
import it.crystalnest.server_sided_portals.api.CustomPortalChecker;
import it.crystalnest.server_sided_portals.api.DimensionTweak;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2424;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2424.class})
public abstract class PortalShapeMixin
implements CustomPortalChecker {
    @Unique
    private boolean finalized = false;
    @Unique
    private class_5321<class_1937> destination = class_1937.field_25179;
    @Unique
    private class_5321<class_1937> dimension = class_1937.field_25179;

    @Shadow
    private static boolean method_10359(class_2680 state) {
        throw new UnsupportedOperationException("Tried to call a dummy body of a shadowed method: PortalShape#isEmpty(BlockState)");
    }

    @ModifyReturnValue(method={"findAnyShape"}, at={@At(value="RETURN")})
    private static class_2424 modifyFindAnyShape(class_2424 original, class_1922 level, class_2338 pos, class_2350.class_2351 axis) {
        if (level instanceof class_3218) {
            class_2350 direction;
            class_3218 serverLevel = (class_3218)level;
            class_2350 class_23502 = direction = axis == class_2350.class_2351.field_11048 ? class_2350.field_11039 : class_2350.field_11035;
            if (original.method_10360()) {
                DimensionTweak tweak = Constants.getTweak((class_5321<class_1937>)class_1937.field_25180);
                if (serverLevel.method_27983() == class_1937.field_25180 || tweak.connection() == serverLevel.method_27983()) {
                    ((CustomPortalChecker)original).setInfos((class_5321<class_1937>)class_1937.field_25180, serverLevel.method_27983() == class_1937.field_25180 ? tweak.connection() : class_1937.field_25180);
                    return original;
                }
                return new class_2424(axis, 0, direction, pos, 0, 0);
            }
            int width = 0;
            class_2338 bottomLeft = null;
            for (class_5321<class_1937> dimension : CustomPortalChecker.getDimensionsWithCustomPortal(serverLevel)) {
                class_6862<class_2248> frameBlock;
                if (dimension != serverLevel.method_27983() && serverLevel.method_27983() != Constants.getTweak(dimension).connection() || (bottomLeft = PortalShapeMixin.calculateBottomLeftForCustomDimension(level, direction, pos, frameBlock = CustomPortalChecker.getCustomPortalFrameTag(dimension))) == null || (width = PortalShapeMixin.calculateWidthForCustomDimension(level, bottomLeft, direction, frameBlock)) <= 0) continue;
                MutableInt portalBlocks = new MutableInt();
                class_2424 portal = new class_2424(axis, portalBlocks.getValue().intValue(), direction, bottomLeft, width, PortalShapeMixin.calculateHeightForCustomDimension(level, bottomLeft, direction, width, portalBlocks, frameBlock));
                if (portal.method_10360()) {
                    ((CustomPortalChecker)portal).setInfos(dimension, serverLevel.method_27983() == dimension ? Constants.getTweak(dimension).connection() : dimension);
                }
                return portal;
            }
            if (bottomLeft == null) {
                return new class_2424(axis, 0, direction, pos, 0, 0);
            }
            if (width == 0) {
                return new class_2424(axis, 0, direction, bottomLeft, 0, 0);
            }
        }
        return original;
    }

    @Unique
    @Nullable
    private static class_2338 calculateBottomLeftForCustomDimension(class_1922 level, class_2350 direction, class_2338 pos, class_6862<class_2248> frameBlock) {
        int i = Math.max(level.method_31607(), pos.method_10264() - 21);
        while (pos.method_10264() > i && PortalShapeMixin.method_10359(level.method_8320(pos.method_10074()))) {
            pos = pos.method_10074();
        }
        class_2350 dir = direction.method_10153();
        int j = PortalShapeMixin.getDistanceUntilEdgeAboveFrameForCustomDimension(level, pos, dir, frameBlock) - 1;
        return j < 0 ? null : pos.method_10079(dir, j);
    }

    @Unique
    private static int calculateWidthForCustomDimension(class_1922 level, class_2338 pos, class_2350 direction, class_6862<class_2248> frameBlock) {
        int i = PortalShapeMixin.getDistanceUntilEdgeAboveFrameForCustomDimension(level, pos, direction, frameBlock);
        return i >= 2 && i <= 21 ? i : 0;
    }

    @Unique
    private static int getDistanceUntilEdgeAboveFrameForCustomDimension(class_1922 level, class_2338 pos, class_2350 direction, class_6862<class_2248> frameBlock) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int i = 0; i <= 21; ++i) {
            class_2680 state = level.method_8320((class_2338)mutablePos.method_10101((class_2382)pos).method_10104(direction, i));
            if (!PortalShapeMixin.method_10359(state)) {
                if (!state.method_26164(frameBlock)) break;
                return i;
            }
            if (!level.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11033)).method_26164(frameBlock)) break;
        }
        return 0;
    }

    @Unique
    private static int calculateHeightForCustomDimension(class_1922 level, class_2338 pos, class_2350 direction, int width, MutableInt portalBlocks, class_6862<class_2248> frameBlock) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        int i = PortalShapeMixin.getDistanceUntilTopForCustomDimension(level, pos, direction, mutablePos, width, portalBlocks, frameBlock);
        return i >= 3 && i <= 21 && PortalShapeMixin.hasTopFrameForCustomDimension(level, pos, direction, mutablePos, width, i, frameBlock) ? i : 0;
    }

    @Unique
    private static int getDistanceUntilTopForCustomDimension(class_1922 level, class_2338 pos, class_2350 direction, class_2338.class_2339 checkPos, int width, MutableInt portalBlocks, class_6862<class_2248> frameBlock) {
        for (int i = 0; i < 21; ++i) {
            checkPos.method_10101((class_2382)pos).method_10104(class_2350.field_11036, i).method_10104(direction, -1);
            if (!level.method_8320((class_2338)checkPos).method_26164(frameBlock)) {
                return i;
            }
            checkPos.method_10101((class_2382)pos).method_10104(class_2350.field_11036, i).method_10104(direction, width);
            if (!level.method_8320((class_2338)checkPos).method_26164(frameBlock)) {
                return i;
            }
            for (int j = 0; j < width; ++j) {
                checkPos.method_10101((class_2382)pos).method_10104(class_2350.field_11036, i).method_10104(direction, j);
                class_2680 blockstate = level.method_8320((class_2338)checkPos);
                if (!PortalShapeMixin.method_10359(blockstate)) {
                    return i;
                }
                if (!blockstate.method_27852(class_2246.field_10316)) continue;
                portalBlocks.increment();
            }
        }
        return 21;
    }

    @Unique
    private static boolean hasTopFrameForCustomDimension(class_1922 level, class_2338 pos, class_2350 direction, class_2338.class_2339 checkPos, int width, int distanceUntilTop, class_6862<class_2248> frameBlock) {
        for (int i = 0; i < width; ++i) {
            class_2338.class_2339 mutablePos = checkPos.method_10101((class_2382)pos).method_10104(class_2350.field_11036, distanceUntilTop).method_10104(direction, i);
            if (level.method_8320((class_2338)mutablePos).method_26164(frameBlock)) continue;
            return false;
        }
        return true;
    }

    @Shadow
    public abstract boolean method_10360();

    @Override
    public class_5321<class_1937> dimension() {
        return this.dimension;
    }

    @Override
    public class_5321<class_1937> destination() {
        return this.destination;
    }

    @Override
    public void setInfos(class_5321<class_1937> dimension, class_5321<class_1937> destination) throws IllegalStateException {
        if (this.finalized) {
            throw new IllegalStateException("Portal dimension was already set");
        }
        this.dimension = dimension;
        this.destination = destination;
        this.finalized = true;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void finalize(class_2350.class_2351 axis, int numPortalBlocks, class_2350 direction, class_2338 bottomLeft, int width, int height, CallbackInfo ci) {
        if (!this.method_10360()) {
            this.setInfos((class_5321<class_1937>)class_1937.field_25179, (class_5321<class_1937>)class_1937.field_25179);
        }
    }
}

