/*
 * Decompiled with CFR 0.152.
 */
package venomized.mc.mods.swsignals;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import venomized.mc.mods.swsignals.AllSounds;
import venomized.mc.mods.swsignals.EventHandler;
import venomized.mc.mods.swsignals.block.se.SeBlocks;
import venomized.mc.mods.swsignals.block.se.SeModels;
import venomized.mc.mods.swsignals.blockentity.se.SeBlockEntities;
import venomized.mc.mods.swsignals.client.ClientEvents;
import venomized.mc.mods.swsignals.client.ForgeClientEvents;
import venomized.mc.mods.swsignals.client.SwMenus;
import venomized.mc.mods.swsignals.data.BlockStateDataGenerator;
import venomized.mc.mods.swsignals.data.RecipeDataGenerator;
import venomized.mc.mods.swsignals.data.SoundEventDataGenerator;
import venomized.mc.mods.swsignals.item.SwItems;
import venomized.mc.mods.swsignals.network.Networking;

@Mod(value="swsignal")
public class SwSignal {
    public static final String MOD_ID = "swsignal";
    public static final Logger LOGGER = LogManager.getLogger(SwSignal.class);
    public static final NonNullSupplier<Registrate> REGISTRATE = NonNullSupplier.lazy(() -> Registrate.create((String)MOD_ID));
    public static final RegistryEntry<CreativeModeTab> SW_SIGNAL_TAB = ((Registrate)REGISTRATE.get()).defaultCreativeTab("extended_signals").register();
    private static Networking SW_SIGNAL_NETWORK;

    public SwSignal() {
        SwSignal.initializeContent();
        IEventBus eventbus = ((Registrate)REGISTRATE.get()).getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        eventbus.register((Object)this);
        AllSounds.SOUNDS.register(eventbus);
        SwMenus.MENUS.register(eventbus);
        EventHandler eventHandler = new EventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientEvents clientEvents = new ClientEvents();
            ForgeClientEvents forgeClientEvents = new ForgeClientEvents();
            eventbus.register((Object)clientEvents);
            MinecraftForge.EVENT_BUS.register((Object)forgeClientEvents);
        });
        SW_SIGNAL_NETWORK = new Networking();
        Networking.init();
    }

    private static void initializeContent() {
        SwSignal.swedishContent();
    }

    private static void swedishContent() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SeModels.init());
        SeBlocks.init();
        SeBlockEntities.init();
        SwItems.init();
    }

    public static final ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static Networking network() {
        return SW_SIGNAL_NETWORK;
    }

    @SubscribeEvent
    public void onDataGenerator(GatherDataEvent e) {
        e.getGenerator().addProvider(true, (DataProvider)new BlockStateDataGenerator(e.getGenerator().getPackOutput(), e.getExistingFileHelper()));
        e.getGenerator().addProvider(true, (DataProvider)new SoundEventDataGenerator(e.getGenerator().getPackOutput(), e.getExistingFileHelper()));
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)new RecipeDataGenerator(e.getGenerator().getPackOutput()));
    }

    @SubscribeEvent
    public void onRegisterEvent(RegisterEvent e) {
    }

    @SubscribeEvent
    public void onCreativeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == SW_SIGNAL_TAB.getKey()) {
            ((Registrate)REGISTRATE.get()).getAll(Registries.f_256913_).forEach(item -> event.m_246326_((ItemLike)item.get()));
        }
    }
}

