/*
 * Decompiled with CFR 0.152.
 */
package venomized.mc.mods.swsignals.blockentity;

import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import venomized.mc.mods.swsignals.blockentity.ISignalTunerBindable;
import venomized.mc.mods.swsignals.blockentity.SwBlockEntity;

public abstract class BlockEntityAbstractSignalBox
extends SwBlockEntity
implements ISignalTunerBindable {
    @Nullable
    protected BlockPos createSignalBlockEntityPosition;
    @Nullable
    protected BlockPos sourceSignalBox;
    protected boolean doLoadExternalSignalBox = true;

    public BlockEntityAbstractSignalBox(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public SignalBlockEntity.SignalState getCreateSignalState() {
        if (this.createSignalBlockEntityPosition == null) {
            return SignalBlockEntity.SignalState.INVALID;
        }
        SignalBlockEntity createSignalBlockEntity = this.getCreateSignalBlockEntity();
        if (createSignalBlockEntity == null) {
            return SignalBlockEntity.SignalState.INVALID;
        }
        SignalBlockEntity.SignalState s = createSignalBlockEntity.getState();
        if (s == null) {
            return SignalBlockEntity.SignalState.INVALID;
        }
        return s;
    }

    public SignalBlockEntity getCreateSignalBlockEntity() {
        if (this.createSignalBlockEntityPosition == null) {
            return null;
        }
        Level level = this.m_58904_();
        if (level == null) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(this.createSignalBlockEntityPosition);
        if (blockEntity instanceof SignalBlockEntity) {
            SignalBlockEntity sbe = (SignalBlockEntity)blockEntity;
            return sbe;
        }
        return null;
    }

    public BlockEntityAbstractSignalBox getSignalBoxBlockEntity() {
        if (this.sourceSignalBox == null) {
            return null;
        }
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.sourceSignalBox);
        if (blockEntity instanceof BlockEntityAbstractSignalBox) {
            BlockEntityAbstractSignalBox sb = (BlockEntityAbstractSignalBox)blockEntity;
            return sb;
        }
        return null;
    }

    public void m_7651_() {
        if (!this.f_58857_.m_5776_() && this.doLoadExternalSignalBox && this.sourceSignalBox != null) {
            ChunkPos chunkPos = new ChunkPos(this.sourceSignalBox);
            ((ServerLevel)this.f_58857_).m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        }
        super.m_7651_();
    }

    public void setCreateSignalSource(BlockPos createSignalPos) {
        this.createSignalBlockEntityPosition = createSignalPos;
        this.updateSelf();
    }

    public void setSignalBoxSource(BlockPos sourceSignalBoxPos) {
        this.sourceSignalBox = sourceSignalBoxPos;
        this.updateSelf();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.createSignalBlockEntityPosition != null) {
            pTag.m_128365_("create_signal_source", (Tag)NbtUtils.m_129224_((BlockPos)this.createSignalBlockEntityPosition));
        } else {
            pTag.m_128379_("create_signal_source_missing", true);
        }
        if (this.sourceSignalBox != null) {
            pTag.m_128365_("source_signalbox_source", (Tag)NbtUtils.m_129224_((BlockPos)this.sourceSignalBox));
        } else {
            pTag.m_128379_("source_signalbox_source_missing", true);
        }
    }

    public void onLoad() {
        this.getSignalBoxBlockEntity();
        super.onLoad();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.createSignalBlockEntityPosition = pTag.m_128441_("create_signal_source") ? NbtUtils.m_129239_((CompoundTag)pTag.m_128469_("create_signal_source")) : null;
        this.sourceSignalBox = pTag.m_128441_("source_signalbox_source") ? NbtUtils.m_129239_((CompoundTag)pTag.m_128469_("source_signalbox_source")) : null;
    }

    public CompoundTag m_5995_() {
        CompoundTag pTag = super.m_5995_();
        this.m_183515_(pTag);
        return pTag;
    }

    @Override
    public Pair<InteractionResult, Component> onBindToSource(Optional<ISignalTunerBindable> sourceBlockEntity, ISignalTunerBindable.SignalTunerMode mode) {
        if (mode == ISignalTunerBindable.SignalTunerMode.DISCONNECT_ALL) {
            this.setSignalBoxSource(null);
            this.setCreateSignalSource(null);
            return Pair.of((Object)InteractionResult.SUCCESS, (Object)Component.m_237113_((String)"Successfully unbound all"));
        }
        if (sourceBlockEntity.isPresent()) {
            ISignalTunerBindable be = sourceBlockEntity.get();
            if (be instanceof SignalBlockEntity) {
                SignalBlockEntity sbe = (SignalBlockEntity)be;
                this.setCreateSignalSource(sbe.m_58899_());
                return Pair.of((Object)InteractionResult.SUCCESS, (Object)Component.m_237113_((String)"Successfully bound to signal"));
            }
            if (be instanceof BlockEntityAbstractSignalBox) {
                BlockEntityAbstractSignalBox sb = (BlockEntityAbstractSignalBox)be;
                this.setSignalBoxSource(sb.m_58899_());
                return Pair.of((Object)InteractionResult.SUCCESS, (Object)Component.m_237113_((String)"Successfully bound to signal box"));
            }
        }
        return Pair.of((Object)InteractionResult.PASS, (Object)Component.m_237113_((String)"No block entity bound"));
    }
}

