/*
 * Decompiled with CFR 0.152.
 */
package venomized.mc.mods.swsignals.blockentity.se.mainsignals;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import venomized.mc.mods.swsignals.blockentity.ISignalTunerBindable;
import venomized.mc.mods.swsignals.blockentity.SwBlockEntity;
import venomized.mc.mods.swsignals.blockentity.se.BlockEntitySignalBox;
import venomized.mc.mods.swsignals.rail.SignalUtilities;
import venomized.mc.mods.swsignals.rail.SwedishSignalAspect;

public abstract class BlockEntitySignal
extends SwBlockEntity
implements IHaveGoggleInformation,
ISignalTunerBindable {
    private static final String SIGNAL_BOX_POS_TAG = "signal_box_pos";
    private final int lightCount;
    public float[] lightLevels;
    private BlockPos signalBoxPosition;
    private int tick;
    private int remainingTicksAspectChangeDelay;

    public BlockEntitySignal(BlockEntityType<?> t, BlockPos pPos, BlockState pBlockState, int lightCount) {
        super(t, pPos, pBlockState);
        this.lightCount = lightCount;
        if (lightCount != -1) {
            this.lightLevels = new float[lightCount];
        }
    }

    public static void commonTick(BlockEntitySignal pBlockEntity, Level pLevel, BlockPos pPos, BlockState pBlockState) {
        pBlockEntity.tick = (pBlockEntity.tick + 1) % 20;
        pBlockEntity.remainingTicksAspectChangeDelay = Math.max(0, pBlockEntity.remainingTicksAspectChangeDelay - 1);
    }

    public static void serverTick(BlockEntitySignal pBlockEntity, Level pLevel, BlockPos pPos, BlockState pBlockState) {
        BlockEntitySignal.commonTick(pBlockEntity, pLevel, pPos, pBlockState);
    }

    public static void clientTick(BlockEntitySignal be, SwedishSignalAspect aspect, SignalBlockEntity.SignalState createSignalState, boolean doInvalidBlinking) {
        BlockEntitySignal.commonTick(be, be.m_58904_(), be.m_58899_(), be.m_58900_());
        be.computeSignalLightValues(aspect, createSignalState, doInvalidBlinking);
    }

    public int getLightCount() {
        return this.lightCount;
    }

    public void setTargetedSignalBoxPosition(BlockPos signalBoxPosition) {
        this.signalBoxPosition = signalBoxPosition;
        this.m_6596_();
        this.updateSelf();
    }

    private BlockEntitySignalBox getConnectedSignalBox() {
        if (this.signalBoxPosition == null) {
            return null;
        }
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.signalBoxPosition);
        if (blockEntity instanceof BlockEntitySignalBox) {
            BlockEntitySignalBox besb = (BlockEntitySignalBox)blockEntity;
            return besb;
        }
        return null;
    }

    public SwedishSignalAspect getCurrentDisplayingAspect() {
        BlockEntitySignalBox connectedSignalBox = this.getConnectedSignalBox();
        if (connectedSignalBox == null) {
            return null;
        }
        return connectedSignalBox.getCurrentAspect();
    }

    public SignalBlockEntity.SignalState getCurrentDisplayingState() {
        BlockEntitySignalBox connectedSignalBox = this.getConnectedSignalBox();
        if (connectedSignalBox == null) {
            return SignalBlockEntity.SignalState.INVALID;
        }
        return connectedSignalBox.getCreateSignalState();
    }

    public boolean valid() {
        return this.getConnectedSignalBox() != null;
    }

    public boolean blink() {
        return this.tick > 10;
    }

    protected void computeSignalLightValues(SwedishSignalAspect aspect, SignalBlockEntity.SignalState createSignalState, boolean doInvalidBlinking) {
        if (doInvalidBlinking || aspect == null) {
            for (int i = 0; i < this.lightLevels.length; ++i) {
                this.lightLevels[i] = this.blink() ? 1.0f : 0.0f;
            }
            return;
        }
        block6: for (int i = 0; i < this.lightCount; ++i) {
            char s = aspect.getLightPattern().charAt(i);
            switch (s) {
                case 'S': {
                    SignalUtilities.computeLightValueAt(i, this.lightLevels, true);
                    continue block6;
                }
                case 'F': {
                    SignalUtilities.computeLightValueAt(i, this.lightLevels, this.blink());
                    continue block6;
                }
                case 'U': {
                    SignalUtilities.computeLightValueAt(i, this.lightLevels, false);
                    continue block6;
                }
                default: {
                    this.lightLevels[i] = this.blink() ? 1.0f : 0.0f;
                }
            }
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.builder((String)"swsignal").add(Component.m_237113_((String)"WIP")).forGoggles(tooltip);
        return true;
    }

    public AABB getRenderBoundingBox() {
        return AABB.m_165882_((Vec3)this.m_58899_().m_252807_(), (double)1.0, (double)2.0, (double)1.0);
    }

    @Override
    public Pair<InteractionResult, Component> onBindToSource(Optional<ISignalTunerBindable> sourceBlockEntity, ISignalTunerBindable.SignalTunerMode mode) {
        ISignalTunerBindable iSignalTunerBindable;
        if (sourceBlockEntity.isPresent() && (iSignalTunerBindable = sourceBlockEntity.get()) instanceof BlockEntitySignalBox) {
            BlockEntitySignalBox sb = (BlockEntitySignalBox)iSignalTunerBindable;
            this.setTargetedSignalBoxPosition(sb.m_58899_());
            return Pair.of((Object)InteractionResult.SUCCESS, (Object)Component.m_237113_((String)"Successfully bound to signal box"));
        }
        return ISignalTunerBindable.super.onBindToSource(sourceBlockEntity, mode);
    }

    @Override
    public boolean isSource() {
        return false;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag syncTag = super.m_5995_();
        this.m_183515_(syncTag);
        return syncTag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.signalBoxPosition = tag.m_128441_(SIGNAL_BOX_POS_TAG) ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_(SIGNAL_BOX_POS_TAG)) : null;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.signalBoxPosition = pTag.m_128441_(SIGNAL_BOX_POS_TAG) ? NbtUtils.m_129239_((CompoundTag)pTag.m_128469_(SIGNAL_BOX_POS_TAG)) : null;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.signalBoxPosition != null) {
            pTag.m_128365_(SIGNAL_BOX_POS_TAG, (Tag)NbtUtils.m_129224_((BlockPos)this.signalBoxPosition));
        } else {
            pTag.m_128379_("signal_box_pos_missing", true);
        }
    }
}

