/*
 * Decompiled with CFR 0.152.
 */
package venomized.mc.mods.swsignals.core.signals;

public abstract class SignalDisplayPattern {
    private float[] lightLevels;
    private int[] lightColors;

    public static float[] intToRGB(int i) {
        float r = (float)(i >> 16 & 0xFF) / 255.0f;
        float g = (float)(i >> 8 & 0xFF) / 255.0f;
        float b = (float)(i & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static int rgbToInt(float r, float g, float b) {
        int i = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        return i;
    }

    public float[] getLightAt(int lightPosition) {
        float[] result = SignalDisplayPattern.intToRGB(this.lightColors[lightPosition]);
        result[0] = result[0] * this.lightLevels[lightPosition];
        result[1] = result[1] * this.lightLevels[lightPosition];
        result[2] = result[2] * this.lightLevels[lightPosition];
        return result;
    }

    public static enum LightStyle {
        UNLIT,
        LIT,
        BLINKING,
        PULSING;

    }
}

