/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.log2discord;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.samxel.log2discord.Log2Discord;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class Log2DiscordConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/log2discord.json");
    public String webhookUrl = "";

    public static Log2DiscordConfig load() {
        Log2DiscordConfig log2DiscordConfig;
        if (!CONFIG_FILE.exists()) {
            Log2DiscordConfig c = new Log2DiscordConfig();
            c.save();
            return c;
        }
        FileReader r = new FileReader(CONFIG_FILE);
        try {
            log2DiscordConfig = (Log2DiscordConfig)GSON.fromJson((Reader)r, Log2DiscordConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Log2Discord.LOGGER.error("Failed to load config", (Throwable)e);
                return new Log2DiscordConfig();
            }
        }
        r.close();
        return log2DiscordConfig;
    }

    public void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter w = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)w);
            }
        }
        catch (IOException e) {
            Log2Discord.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }
}

