/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.blocks;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.sashakyotoz.wrathy_armament.entities.bosses.BossLikePathfinderMob;
import net.sashakyotoz.wrathy_armament.entities.bosses.Habciak;
import net.sashakyotoz.wrathy_armament.entities.bosses.JohannesKnight;
import net.sashakyotoz.wrathy_armament.entities.bosses.LichKing;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentEntities;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentItems;
import net.sashakyotoz.wrathy_armament.utils.OnActionsTrigger;
import org.antlr.v4.runtime.misc.Triple;

public class HandlerStoneBlock
extends Block {
    public static final IntegerProperty SWORD_INDEX = IntegerProperty.m_61631_((String)"sword_index", (int)0, (int)5);
    public static final BooleanProperty CONTAINS_KEEPER = BooleanProperty.m_61465_((String)"contains_keeper");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private final VoxelShape SWORD_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{HandlerStoneBlock.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)});

    public HandlerStoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SWORD_INDEX, (Comparable)Integer.valueOf(0))).m_61124_((Property)CONTAINS_KEEPER, (Comparable)Boolean.valueOf(false)));
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return (Integer)state.m_61143_((Property)SWORD_INDEX) > 0 ? 8 : 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)SWORD_INDEX) > 0 ? this.SWORD_SHAPE : BASE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{SWORD_INDEX});
        builder.m_61104_(new Property[]{CONTAINS_KEEPER});
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if (((Boolean)state.m_61143_((Property)CONTAINS_KEEPER)).booleanValue() && source.m_188499_()) {
            OnActionsTrigger.addParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, level.m_8055_(pos.m_7495_())), (Level)level, pos.m_123341_(), (float)pos.m_123342_() + 0.5f, pos.m_123343_(), 2.0f);
        }
        super.m_213898_(state, level, pos, source);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Boolean)state.m_61143_((Property)CONTAINS_KEEPER)).booleanValue() && level.m_8055_(pos.m_7494_()).m_60795_()) {
            switch ((Integer)state.m_61143_((Property)SWORD_INDEX)) {
                case 1: {
                    ItemStack stack = ((Item)WrathyArmamentItems.MASTER_SWORD.get()).m_7968_();
                    player.m_36335_().m_41524_(stack.m_41720_(), 200);
                    player.m_19983_(stack);
                    HandlerStoneBlock.provokeCollapse(player, level, pos, 18, 20);
                    List<LivingEntity> entityList = level.m_6443_(LivingEntity.class, new AABB(pos.m_252807_(), pos.m_252807_()).m_82400_(16.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(pos.m_252807_()))).toList();
                    for (LivingEntity entity2 : entityList) {
                        if (!(entity2 instanceof Player)) continue;
                        Player player1 = (Player)entity2;
                        OnActionsTrigger.playerCameraData.computeIfAbsent(player1.m_20149_(), k -> new Triple((Object)0, (Object)0, (Object)0));
                        OnActionsTrigger.playerCameraData.put(player1.m_20149_(), (Triple<Integer, Integer, Integer>)new Triple((Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player1.m_20149_()).a + 100), (Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player1.m_20149_()).b), (Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player1.m_20149_()).c)));
                    }
                    OnActionsTrigger.vec3 = pos.m_252807_();
                    OnActionsTrigger.queueServerWork(20, () -> this.waveFlaming(level, pos));
                    OnActionsTrigger.queueServerWork(100, () -> {
                        OnActionsTrigger.vec3 = new Vec3(0.0, -256.0, 0.0);
                    });
                    break;
                }
                case 2: {
                    this.waveFlaming(level, pos);
                    OnActionsTrigger.queueServerWork(30, () -> {
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            LichKing king = new LichKing((EntityType<? extends BossLikePathfinderMob>)((EntityType)WrathyArmamentEntities.LICH_KING.get()), (Level)serverLevel);
                            king.m_20219_(pos.m_7494_().m_252807_().m_272010_(RandomSource.m_216327_(), 3.0f));
                            serverLevel.m_7967_((Entity)king);
                        }
                    });
                    break;
                }
                case 3: {
                    this.waveFlaming(level, pos);
                    OnActionsTrigger.queueServerWork(30, () -> {
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            JohannesKnight knight = new JohannesKnight((EntityType<? extends JohannesKnight>)((EntityType)WrathyArmamentEntities.JOHANNES_KNIGHT.get()), (Level)serverLevel);
                            knight.m_20219_(pos.m_252807_().m_272010_(RandomSource.m_216327_(), 3.0f));
                            serverLevel.m_7967_((Entity)knight);
                        }
                    });
                    break;
                }
                case 4: {
                    this.waveFlaming(level, pos);
                    OnActionsTrigger.queueServerWork(30, () -> {
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            Habciak habciak = new Habciak((EntityType<? extends PathfinderMob>)((EntityType)WrathyArmamentEntities.HABCIAK.get()), (Level)serverLevel);
                            habciak.m_20219_(pos.m_252807_().m_272010_(RandomSource.m_216327_(), 3.0f));
                            serverLevel.m_7967_((Entity)habciak);
                        }
                    });
                    List<LivingEntity> entityList = level.m_6443_(LivingEntity.class, new AABB(pos.m_252807_(), pos.m_252807_()).m_82400_(16.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(pos.m_252807_()))).toList();
                    for (LivingEntity entity3 : entityList) {
                        if (!(entity3 instanceof Player)) continue;
                        Player player1 = (Player)entity3;
                        OnActionsTrigger.playerCameraData.computeIfAbsent(player1.m_20149_(), k -> new Triple((Object)0, (Object)0, (Object)0));
                        OnActionsTrigger.playerCameraData.put(player1.m_20149_(), (Triple<Integer, Integer, Integer>)new Triple((Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player1.m_20149_()).a + 80), (Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player1.m_20149_()).b), (Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player1.m_20149_()).c)));
                    }
                    OnActionsTrigger.vec3 = pos.m_252807_();
                    OnActionsTrigger.queueServerWork(20, () -> this.waveFlaming(level, pos));
                    OnActionsTrigger.queueServerWork(100, () -> {
                        OnActionsTrigger.vec3 = new Vec3(0.0, -256.0, 0.0);
                    });
                    break;
                }
                case 5: {
                    ItemStack stack = ((Item)WrathyArmamentItems.BLACKRAZOR.get()).m_7968_();
                    player.m_36335_().m_41524_(stack.m_41720_(), 200);
                    player.m_19983_(stack);
                    HandlerStoneBlock.provokeCollapse(player, level, pos, 16, 8);
                    List<LivingEntity> entityList = level.m_6443_(LivingEntity.class, new AABB(pos.m_252807_(), pos.m_252807_()).m_82400_(16.0), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(pos.m_252807_()))).toList();
                    for (LivingEntity entity4 : entityList) {
                        if (!(entity4 instanceof Player)) continue;
                        Player player1 = (Player)entity4;
                        OnActionsTrigger.playerCameraData.computeIfAbsent(player1.m_20149_(), k -> new Triple((Object)0, (Object)0, (Object)0));
                        OnActionsTrigger.playerCameraData.put(player1.m_20149_(), (Triple<Integer, Integer, Integer>)new Triple((Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player1.m_20149_()).a + 100), (Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player1.m_20149_()).b), (Object)((Integer)OnActionsTrigger.playerCameraData.get((Object)player1.m_20149_()).c)));
                    }
                    OnActionsTrigger.vec3 = pos.m_252807_();
                    OnActionsTrigger.queueServerWork(100, () -> {
                        OnActionsTrigger.vec3 = new Vec3(0.0, -256.0, 0.0);
                    });
                }
            }
            level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)SWORD_INDEX, (Comparable)Integer.valueOf(0)), 3);
            level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)CONTAINS_KEEPER, (Comparable)Boolean.valueOf(false)), 3);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public static void provokeCollapse(@Nullable Player player, Level level, BlockPos pos, int radius, int yOffset) {
        for (int y = -radius + yOffset; y < radius - yOffset / 3; ++y) {
            for (int x = -radius; x < radius; ++x) {
                for (int z = -radius; z < radius; ++z) {
                    int finalX = x;
                    int finalY = y;
                    int finalZ = z;
                    if (player != null && player.f_19797_ % 10 == 0) {
                        player.m_5496_(SoundEvents.f_12601_, 2.0f, 2.0f);
                    }
                    OnActionsTrigger.queueServerWork(10, () -> {
                        if (level.m_8055_(pos.m_7918_(finalX, finalY, finalZ)).m_60815_() && level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            BlockPos pos1 = pos.m_7918_(finalX, finalY, finalZ);
                            if ((double)level.f_46441_.m_188501_() > 0.65) {
                                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, level.m_8055_(pos1)), (double)pos1.m_123341_(), (double)(pos1.m_123342_() - 1), (double)pos1.m_123343_(), 0.0, -1.0, 0.0);
                            } else {
                                FallingBlockEntity.m_201971_((Level)serverLevel, (BlockPos)pos1, (BlockState)level.m_8055_(pos1));
                            }
                        }
                    });
                }
            }
        }
    }

    private void waveFlaming(Level level, BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            int finalI = i;
            OnActionsTrigger.queueServerWork(20 + 10 * i, () -> OnActionsTrigger.addParticles((ParticleOptions)ParticleTypes.f_123810_, level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 2 * finalI));
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)SWORD_INDEX) > 0 ? 8 : 0;
    }
}

