/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.blocks.entities;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.sashakyotoz.anitexlib.client.particles.parents.options.ColorableParticleOption;
import net.sashakyotoz.wrathy_armament.blocks.entities.recipes.SimpleCraftingContainer;
import net.sashakyotoz.wrathy_armament.blocks.entities.recipes.WorldshardWorkbenchRecipe;
import net.sashakyotoz.wrathy_armament.blocks.gui.WorldshardWorkbenchMenu;
import net.sashakyotoz.wrathy_armament.items.SwordLikeItem;
import net.sashakyotoz.wrathy_armament.registers.WrathyArmamentBlockEntities;
import net.sashakyotoz.wrathy_armament.utils.capabilities.items.XPTiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldshardWorkbenchBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            WorldshardWorkbenchBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> WorldshardWorkbenchBlockEntity.this.progress;
                case 1 -> WorldshardWorkbenchBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    WorldshardWorkbenchBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    WorldshardWorkbenchBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    public int progress = 0;
    private int maxProgress = 300;

    public WorldshardWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)WrathyArmamentBlockEntities.WORLDSHARD_WORKBENCH.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.wrathy_armament.worldshard_workbench");
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("menus", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("workbench.progress", this.progress);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("menus"));
        this.progress = nbt.m_128451_("workbench.progress");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new WorldshardWorkbenchMenu(i, inventory, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.m_58904_(), (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void tick(Level level, BlockPos pos, BlockState state, WorldshardWorkbenchBlockEntity blockEntity) {
        ItemStack mainStack = blockEntity.itemHandler.getStackInSlot(0);
        if (level.m_5776_()) {
            if (mainStack.m_41720_() instanceof SwordLikeItem && mainStack.m_41784_().m_128451_("Sparkles") < 5 && mainStack.m_41784_().m_128451_("CombatExperience") > XPTiers.values()[mainStack.m_41784_().m_128451_("Sparkles")].getNeededXP()) {
                int remainingUseTicks = blockEntity.maxProgress - blockEntity.progress;
                float sin = (float)Math.sin((double)remainingUseTicks * Math.PI / 10.0);
                float cos = (float)Math.cos((double)remainingUseTicks * Math.PI / 10.0);
                if (blockEntity.progress % 15 == 0) {
                    level.m_245747_(pos, SoundEvents.f_11739_, SoundSource.BLOCKS, 1.5f, 0.75f, true);
                }
                level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)((float)pos.m_123341_() + 0.5f + sin), (double)((float)pos.m_123342_() + 1.1f), (double)((float)pos.m_123343_() + 0.5f + cos), 0.0, 0.0, 0.0);
            }
            if (this.hasRecipe() && blockEntity.progress % 15 == 0) {
                level.m_245747_(pos, SoundEvents.f_11738_, SoundSource.BLOCKS, 1.5f, 0.75f, true);
            }
        }
        boolean isCraftingAction = mainStack.m_41720_() instanceof SmithingTemplateItem;
        float[] colors = new float[3];
        switch (this.getModelVariantForRecipe()) {
            case 0: {
                colors[0] = 0.1f;
                colors[1] = 1.0f;
                colors[2] = 0.0f;
                break;
            }
            case 1: {
                colors[0] = 0.1f;
                colors[1] = 0.1f;
                colors[2] = 0.1f;
                break;
            }
            case 2: {
                colors[0] = 1.0f;
                colors[1] = 0.0f;
                colors[2] = 0.75f;
                break;
            }
            case 3: {
                colors[0] = 0.25f;
                colors[1] = 0.1f;
                colors[2] = 0.1f;
            }
        }
        if (this.hasRecipe() || !isCraftingAction && mainStack.m_41720_() instanceof SwordLikeItem) {
            if (isCraftingAction) {
                if (RandomSource.m_216327_().m_188499_()) {
                    ++blockEntity.progress;
                }
            } else if (mainStack.m_41784_().m_128451_("Sparkles") < 5 && mainStack.m_41784_().m_128451_("CombatExperience") > XPTiers.values()[mainStack.m_41784_().m_128451_("Sparkles")].getNeededXP()) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress % 2 == 0 && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new ColorableParticleOption("sparkle", colors[0], colors[1], colors[2]), (double)((float)pos.m_123341_() + 0.5f), (double)(pos.m_123342_() + 1), (double)((float)pos.m_123343_() + 0.5f), 2, 0.0, 0.0, 0.0, 0.5);
            }
            WorldshardWorkbenchBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (blockEntity.progress >= blockEntity.maxProgress) {
                if (isCraftingAction) {
                    this.craftItem(blockEntity);
                } else {
                    ItemStack modifiedStack = mainStack.m_41777_();
                    modifiedStack.m_41784_().m_128405_("CombatExperience", modifiedStack.m_41784_().m_128451_("CombatExperience") - XPTiers.values()[modifiedStack.m_41784_().m_128451_("Sparkles")].getNeededXP());
                    modifiedStack.m_41784_().m_128405_("Sparkles", modifiedStack.m_41784_().m_128451_("Sparkles") + 1);
                    blockEntity.itemHandler.extractItem(0, 1, false);
                    blockEntity.itemHandler.insertItem(9, modifiedStack, false);
                    blockEntity.resetProgress();
                }
            }
        } else {
            blockEntity.resetProgress();
            WorldshardWorkbenchBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public ItemStack stackToRender() {
        return this.itemHandler.getStackInSlot(9);
    }

    public int getModelVariantForRecipe() {
        if (this.getCurrentRecipe().isEmpty()) {
            return -1;
        }
        Optional<WorldshardWorkbenchRecipe> matchedRecipe = this.getCurrentRecipe();
        ItemStack stackToIdentifyModel = matchedRecipe.get().m_8043_(null);
        if (stackToIdentifyModel.m_150930_(Items.f_265887_)) {
            return 0;
        }
        if (stackToIdentifyModel.m_150930_(Items.f_276546_)) {
            return 1;
        }
        if (stackToIdentifyModel.m_150930_(Items.f_265965_)) {
            return 2;
        }
        if (stackToIdentifyModel.m_150930_(Items.f_266114_)) {
            return 3;
        }
        return -1;
    }

    private void craftItem(WorldshardWorkbenchBlockEntity pEntity) {
        Optional<WorldshardWorkbenchRecipe> matchedRecipe = this.getCurrentRecipe();
        if (matchedRecipe.isPresent()) {
            ItemStack result = matchedRecipe.get().m_8043_(pEntity.m_58904_().m_9598_());
            for (int i = 0; i < 9; ++i) {
                pEntity.itemHandler.extractItem(i, 1, false);
            }
            this.itemHandler.setStackInSlot(9, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(9).m_41613_() + result.m_41613_()));
            pEntity.resetProgress();
        }
    }

    public boolean hasRecipe() {
        Optional<WorldshardWorkbenchRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private Optional<WorldshardWorkbenchRecipe> getCurrentRecipe() {
        SimpleCraftingContainer inventory = new SimpleCraftingContainer(3, 3, this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.m_58904_().m_7465_().m_44015_((RecipeType)WorldshardWorkbenchRecipe.Type.INSTANCE, (Container)inventory, this.m_58904_());
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(9).m_41619_() || this.itemHandler.getStackInSlot(9).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(9).m_41613_() + count <= this.itemHandler.getStackInSlot(9).m_41741_();
    }
}

