/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.wrathy_armament.blocks.entities.recipes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.sashakyotoz.wrathy_armament.blocks.entities.recipes.SimpleCraftingContainer;

public class WorldshardWorkbenchRecipe
implements Recipe<SimpleCraftingContainer> {
    private final int width;
    private final int height;
    private final NonNullList<Ingredient> input;
    private final ResourceLocation id;
    private final ItemStack output;

    public WorldshardWorkbenchRecipe(ResourceLocation id, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack output) {
        this.width = width;
        this.height = height;
        this.id = id;
        this.input = recipeItems;
        this.output = output;
    }

    public boolean matches(SimpleCraftingContainer pContainer, Level pLevel) {
        for (int i = 0; i <= pContainer.getWidth() - this.width; ++i) {
            for (int j = 0; j <= pContainer.getHeight() - this.height; ++j) {
                if (this.matchesPattern(pContainer, i, j, true)) {
                    return true;
                }
                if (!this.matchesPattern(pContainer, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList completeInput = NonNullList.m_122779_();
        for (int i = 0; i < this.input.size(); ++i) {
            completeInput.add(i, (Object)((Ingredient)this.input.get(i)));
        }
        return completeInput;
    }

    public ItemStack assemble(SimpleCraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    private boolean matchesPattern(SimpleCraftingContainer inv, int offsetX, int offsetY, boolean flipped) {
        for (int i = 0; i < inv.getWidth(); ++i) {
            for (int j = 0; j < inv.getHeight(); ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = flipped ? (Ingredient)this.input.get(this.width - k - 1 + l * this.width) : (Ingredient)this.input.get(k + l * this.width);
                }
                if (ingredient.test(inv.m_8020_(i + j * inv.getWidth()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return this.width >= this.width && this.height >= this.height;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    static NonNullList<Ingredient> dissolvePattern(String[] pPattern, Map<String, Ingredient> pKeys, int pPatternWidth, int pPatternHeight) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(pPatternWidth * pPatternHeight), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(pKeys.keySet());
        set.remove(" ");
        for (int i = 0; i < pPattern.length; ++i) {
            for (int j = 0; j < pPattern[i].length(); ++j) {
                String s = pPattern[i].substring(j, j + 1);
                Ingredient ingredient = pKeys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + pPatternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... pToShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < pToShrink.length; ++i1) {
            String s = pToShrink[i1];
            i = Math.min(i, WorldshardWorkbenchRecipe.firstNonSpace(s));
            int j1 = WorldshardWorkbenchRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pToShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[pToShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = pToShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> nonnulllist = this.m_7527_();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(ingredient -> !ingredient.m_43947_()).anyMatch(p_151273_ -> ForgeHooks.hasNoElements((Ingredient)p_151273_));
    }

    private static int firstNonSpace(String pEntry) {
        int i;
        for (i = 0; i < pEntry.length() && pEntry.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String pEntry) {
        int i;
        for (i = pEntry.length() - 1; i >= 0 && pEntry.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] patternFromJson(JsonArray pPatternArray) {
        String[] astring = new String[pPatternArray.size()];
        if (astring.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)pPatternArray.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    static Map<String, Ingredient> keyFromJson(JsonObject pKeyEntry) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : pKeyEntry.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_288218_((JsonElement)((JsonElement)entry.getValue()), (boolean)false));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack itemStackFromJson(JsonObject pStackObject) {
        return CraftingHelper.getItemStack((JsonObject)pStackObject, (boolean)true, (boolean)true);
    }

    public static Item itemFromJson(JsonObject pItemObject) {
        String s = GsonHelper.m_13906_((JsonObject)pItemObject, (String)"item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)s));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Empty ingredient not allowed here");
        }
        return item;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<WorldshardWorkbenchRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public WorldshardWorkbenchRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            Map<String, Ingredient> map = WorldshardWorkbenchRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)pJson, (String)"key"));
            String[] astring = WorldshardWorkbenchRecipe.shrink(WorldshardWorkbenchRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = WorldshardWorkbenchRecipe.dissolvePattern(astring, map, i, j);
            ItemStack itemstack = WorldshardWorkbenchRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            return new WorldshardWorkbenchRecipe(pRecipeId, i, j, nonnulllist, itemstack);
        }

        public WorldshardWorkbenchRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int i = pBuffer.m_130242_();
            int j = pBuffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            nonnulllist.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            ItemStack itemstack = pBuffer.m_130267_();
            return new WorldshardWorkbenchRecipe(pRecipeId, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, WorldshardWorkbenchRecipe pRecipe) {
            pBuffer.m_130130_(pRecipe.width);
            pBuffer.m_130130_(pRecipe.height);
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.m_130055_(pRecipe.output);
        }
    }

    public static class Type
    implements RecipeType<WorldshardWorkbenchRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

